package cn.airfei.aircore.core.extend;

import cn.airfei.aircore.core.properties.AirCoreProperty;
import cn.airfei.aircore.core.storage.Pojo.LogForMongoDbPojo;
import cn.airfei.aircore.core.storage.bo.TokenBo;
import cn.airfei.aircore.core.utils.EncryptionUtil;
import com.alibaba.fastjson2.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @description: 解析头部的 Authorization
 * @author: air
 * @create: 2020-11-13 09:14
 */
@Component
public class ParseHeaderAuthorization {
    @Resource
    private AirCoreProperty airCoreProperty;

    /**
     * 解析请求头中的 Authorization
     *
     * @return
     */
    public TokenBo parse() {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        // 判断是否直接用秘钥解析token
        if (airCoreProperty.isPermitParseToken()) {
            String token = request.getHeader("Authorization");
            if (StringUtils.isEmpty(token)) {
                return null;
            }
            token = token.replace("Bearer ", "");
            // 判断token是否为空,或者token过短则直接跳过
            if (!StringUtils.isEmpty(token) && token.length() >= 24) {
                try {
                    String desToken = EncryptionUtil.desEncrypt(token, airCoreProperty.getEncryptKey(), airCoreProperty.getEncryptIv());
                    return JSONObject.parseObject(desToken, TokenBo.class);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /**
     * 组装登录用户信息
     *
     * @param logForMongoDbPojo
     * @return
     */
    public LogForMongoDbPojo setLoginInfo(LogForMongoDbPojo logForMongoDbPojo) {
        TokenBo tokenBo = parse();
        if (tokenBo == null) {
            return logForMongoDbPojo;
        }
        logForMongoDbPojo.setUserId(tokenBo.getUserId());
        logForMongoDbPojo.setUsername(tokenBo.getUsername());
        logForMongoDbPojo.setNickname(tokenBo.getNickname());
        logForMongoDbPojo.setPlatFormId(tokenBo.getPlatFormId());
        logForMongoDbPojo.setMobile(tokenBo.getMobile());
        logForMongoDbPojo.setUuid(tokenBo.getUuid());
        logForMongoDbPojo.setExpirationTime(tokenBo.getExpirationTime());
        return logForMongoDbPojo;
    }


    /**
     * 获取登录的用户id
     *
     * @return
     */
    public Long getLoginUserId() {
        TokenBo tokenBo = parse();
        if (tokenBo != null) {
            return tokenBo.getUserId();
        }
        return null;
    }


    /**
     * 获取登录用户名
     *
     * @return
     */
    public String getLoginUserName() {
        TokenBo tokenBo = parse();
        if (tokenBo != null) {
            return tokenBo.getUsername();
        }
        return null;
    }


    /**
     * 获取登录用户手机号
     *
     * @return
     */
    public Long getLoginMobile() {
        TokenBo tokenBo = parse();
        if (tokenBo != null) {
            return tokenBo.getMobile();
        }
        return null;
    }
}
