package cn.airfei.aircore.core.extend;

import cn.airfei.aircore.core.properties.AirCoreProperty;
import cn.airfei.aircore.core.storage.Pojo.LogForMongoDbPojo;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @description:
 * @author: air
 * @create: 2020-11-06 11:14
 */
@Component
@EnableAsync
public class InsertLogToMongoDb {
    @Resource
    private MongoTemplate mongoTemplate;

    @Resource
    private AirCoreProperty airCoreProperty;

    @Async
    public void insertLog(LogForMongoDbPojo logForMongoDbPojo) {

        if (airCoreProperty.getSetLogToMongoDb()) {
            mongoTemplate.insert(logForMongoDbPojo, airCoreProperty.getWebLogTableNameForMongoDb());
        }
    }


}
