/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.utils;

import cn.airfei.aircore.core.utils.SpringContextUtil;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDbUtil {
    private final String collectionName;
    private Query query;
    private final MongoTemplate mongoTemplate = (MongoTemplate)SpringContextUtil.getBean("mongoTemplate");

    public MongoDbUtil(String collectionName) {
        this.collectionName = collectionName;
        this.query = new Query();
    }

    public MongoDbUtil clear() {
        this.query = new Query();
        return this;
    }

    public MongoDbUtil query(Map<String, String> map) {
        for (String key : map.keySet()) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).is((Object)map.get(key)));
        }
        return this;
    }

    public MongoDbUtil query(String key, String value) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).is((Object)value));
        return this;
    }

    public MongoDbUtil queryMixture(Map<String, String> map) {
        for (String key : map.keySet()) {
            this.assembleQuery(key, map.get(key));
        }
        return this;
    }

    public MongoDbUtil queryIn(String key, Object min, Object max) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).in(new Object[]{min, max}));
        return this;
    }

    public MongoDbUtil limit(Integer limit) {
        this.query.limit(limit.intValue());
        return this;
    }

    public MongoDbUtil sort(String key, boolean isDesc) {
        if (isDesc) {
            this.query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)key)}));
        } else {
            this.query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)key)}));
        }
        return this;
    }

    public Object find() {
        return this.mongoTemplate.find(this.query, Map.class, this.collectionName);
    }

    public Object findOne() {
        return this.mongoTemplate.findOne(this.query, Map.class, this.collectionName);
    }

    public Object findAll() {
        return this.mongoTemplate.findAll(Map.class, this.collectionName);
    }

    public Object insert(Object obj) {
        return this.mongoTemplate.insert(obj, this.collectionName);
    }

    public Long count() {
        return this.mongoTemplate.count(this.query, this.collectionName);
    }

    public Object selectByTraceId(String traceId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"traceId").is((Object)traceId)).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        return this.mongoTemplate.find(query, Map.class, this.collectionName);
    }

    private void assembleQuery(String key, String value) {
        String[] stringArr = key.split("-");
        if (stringArr[0].equals("qp") && stringArr.length == 3) {
            switch (stringArr[2]) {
                case "is": {
                    this.query.addCriteria((CriteriaDefinition)Criteria.where((String)stringArr[1]).is((Object)value));
                    break;
                }
                case "ne": {
                    this.query.addCriteria((CriteriaDefinition)Criteria.where((String)stringArr[1]).ne((Object)value));
                    break;
                }
                case "gt": {
                    this.query.addCriteria((CriteriaDefinition)Criteria.where((String)stringArr[1]).gt((Object)value));
                    break;
                }
                case "lt": {
                    this.query.addCriteria((CriteriaDefinition)Criteria.where((String)stringArr[1]).lt((Object)value));
                    break;
                }
                case "gte": {
                    this.query.addCriteria((CriteriaDefinition)Criteria.where((String)stringArr[1]).gte((Object)value));
                    break;
                }
                case "in": {
                    this.query.addCriteria((CriteriaDefinition)Criteria.where((String)stringArr[1]).in(new Object[]{value}));
                    break;
                }
                case "regex": {
                    this.query.addCriteria((CriteriaDefinition)Criteria.where((String)stringArr[1]).regex(value));
                }
            }
        }
    }
}

