/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.generator;

import cn.airfei.aircore.core.properties.CodeGeneratorProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.TemplateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class CodeGenerator {
    private DataSourceProperties dataSourceProperties;
    private CodeGeneratorProperty codeGeneratorProperty;

    public void generator(DataSourceProperties dataSourceProperties, CodeGeneratorProperty codeGeneratorProperty) {
        this.codeGeneratorProperty = codeGeneratorProperty;
        this.dataSourceProperties = dataSourceProperties;
        this.generatorStorage("vo");
        this.generatorStorage("entity");
        this.generatorStorage("dto");
        this.generatorService("service");
        this.generatorService("domainService");
        this.generatorPomXml("storages");
        this.generatorPomXml("services");
        this.generatorPomXml("infrastructure");
        this.generatorInfrastructure();
        this.generatorConvertor();
        this.generatorControllerApi();
        this.generatorController();
        this.generatorConfig("cors");
    }

    private void generatorStorage(String storageType) {
        System.out.println("------------fastAutoGeneratorCustom generatorStorage--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + "storages/src/main/java")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent() + ".storages").entity(storageType).moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, this.codeGeneratorProperty.getOutputDir() + "/storages"))).templateConfig(builder -> {
            if (storageType.equals("vo")) {
                builder.entity("/templates/air/vo.java").disable(new TemplateType[]{TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.SERVICEIMPL, TemplateType.XML});
            }
            if (storageType.equals("dto")) {
                builder.entity("/templates/air/dto.java").disable(new TemplateType[]{TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.SERVICEIMPL, TemplateType.XML});
            }
            if (storageType.equals("entity")) {
                builder.entity("/templates/air/entity.java").disable(new TemplateType[]{TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.SERVICEIMPL, TemplateType.XML});
            }
        }).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            String suffix = null;
            if (storageType.equals("vo")) {
                suffix = "Vo";
            }
            if (storageType.equals("dto")) {
                suffix = "Dto";
            }
            if (storageType.equals("entity")) {
                suffix = "";
            }
            builder.entityBuilder().naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel).enableLombok().idType(IdType.ASSIGN_ID).formatFileName("%s" + suffix);
            if (storageType.equals("entity")) {
                // empty if block
            }
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorService(String serviceType) {
        System.out.println("------------fastAutoGeneratorCustom generatorService--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + "services/src/main/java")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent() + ".services").service(serviceType).serviceImpl(serviceType + ".impl").moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp"))).templateConfig(builder -> {
            if (serviceType.equals("domainService")) {
                builder.service("/templates/air/domainservice.java").serviceImpl("/templates/air/domainserviceImpl.java").disable(new TemplateType[]{TemplateType.CONTROLLER, TemplateType.MAPPER, TemplateType.ENTITY});
            }
            if (serviceType.equals("service")) {
                builder.service("/templates/air/service.java").serviceImpl("/templates/air/serviceImpl.java").disable(new TemplateType[]{TemplateType.CONTROLLER, TemplateType.MAPPER, TemplateType.ENTITY});
            }
        }).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            if (serviceType.equals("domainService")) {
                builder.serviceBuilder().formatServiceFileName("%sDomainService").formatServiceImplFileName("%sDomainServiceImpl");
            }
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorController() {
        System.out.println("------------fastAutoGeneratorCustom generatorController--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getProjectPath() + "/src/main/java/")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent()).moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp"))).templateConfig(builder -> builder.controller("/templates/air/controller.java").disable(new TemplateType[]{TemplateType.SERVICEIMPL, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.ENTITY, TemplateType.XML})).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            builder.controllerBuilder().enableRestStyle();
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorControllerApi() {
        System.out.println("------------fastAutoGeneratorCustom generatorControllerApi--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getProjectPath() + "/src/main/java/")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent()).controller("api").moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp"))).templateConfig(builder -> builder.controller("/templates/air/api.java").disable(new TemplateType[]{TemplateType.SERVICEIMPL, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.ENTITY})).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            builder.controllerBuilder().formatFileName("%sApi");
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorConvertor() {
        System.out.println("------------fastAutoGeneratorCustom generatorConvertor--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + "storages/src/main/java")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent() + ".storages").controller("convertor").moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp"))).templateConfig(builder -> builder.controller("/templates/air/convertor.java").disable(new TemplateType[]{TemplateType.SERVICEIMPL, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.ENTITY})).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            builder.controllerBuilder().formatFileName("%sConvertor");
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorInfrastructure() {
        System.out.println("------------fastAutoGeneratorCustom generatorInfrastructure--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + "infrastructure/src/main/java")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent() + ".infrastructure").moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, this.codeGeneratorProperty.getOutputDir() + "infrastructure/src/main/resources/mapper/" + this.codeGeneratorProperty.getModuleName()))).templateConfig(builder -> builder.mapper("/templates/air/mapper.java").xml("/templates/air/mapper.xml").disable(new TemplateType[]{TemplateType.SERVICEIMPL, TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.ENTITY})).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorPomXml(String modelName) {
        System.out.println("------------fastAutoGeneratorCustom generatorPomXml--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        injectionConfigMap.put("PomName", modelName);
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + modelName)).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent()).moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, this.codeGeneratorProperty.getOutputDir() + modelName))).templateConfig(builder -> builder.xml("/templates/air/pom.xml").disable(new TemplateType[]{TemplateType.SERVICEIMPL, TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.ENTITY, TemplateType.MAPPER})).strategyConfig(builder -> builder.mapperBuilder().formatXmlFileName("pom")).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorConfig(String configType) {
        System.out.println("------------fastAutoGeneratorCustom generatorConfig--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getProjectPath() + "/src/main/java/")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent()).controller("config").moduleName(this.codeGeneratorProperty.getModuleName())).templateConfig(builder -> {
            String template = "";
            if (configType.equals("swagger")) {
                template = "/templates/air/swagger3Config.java";
            }
            if (configType.equals("cors")) {
                template = "/templates/air/corsConfig.java";
            }
            if (configType.equals("redisson")) {
                template = "/templates/air/redissonConfig.java";
            }
            builder.controller(template).disable(new TemplateType[]{TemplateType.SERVICEIMPL, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.ENTITY, TemplateType.XML});
        }).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            if (configType.equals("swagger")) {
                builder.controllerBuilder().formatFileName("Swagger3Config");
            }
            if (configType.equals("cors")) {
                builder.controllerBuilder().formatFileName("CORSConfig");
            }
            if (configType.equals("redisson")) {
                builder.controllerBuilder().formatFileName("RedissonConfig");
            }
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private Map<String, Object> injectionConfigMap() {
        HashMap<String, Object> injectionConfigMap = new HashMap<String, Object>();
        String moduleNameName = this.codeGeneratorProperty.getModuleName();
        if (StringUtils.isNotEmpty((CharSequence)moduleNameName)) {
            moduleNameName = "." + moduleNameName;
        }
        injectionConfigMap.put("Api", this.codeGeneratorProperty.getParent() + moduleNameName + ".api");
        injectionConfigMap.put("Po", this.codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".po");
        injectionConfigMap.put("Vo", this.codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".vo");
        injectionConfigMap.put("Dto", this.codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".dto");
        injectionConfigMap.put("Entity", this.codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".entity");
        injectionConfigMap.put("Service", this.codeGeneratorProperty.getParent() + ".services" + moduleNameName + ".service");
        injectionConfigMap.put("DomainService", this.codeGeneratorProperty.getParent() + ".services" + moduleNameName + ".domainService");
        injectionConfigMap.put("ServiceImpl", this.codeGeneratorProperty.getParent() + ".services" + moduleNameName + ".service.impl");
        injectionConfigMap.put("DomainServiceImpl", this.codeGeneratorProperty.getParent() + ".services" + moduleNameName + ".domainService.impl");
        injectionConfigMap.put("Convertor", this.codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".convertor");
        injectionConfigMap.put("Config", this.codeGeneratorProperty.getParent() + moduleNameName + ".config");
        injectionConfigMap.put("Parent", this.codeGeneratorProperty.getParent());
        injectionConfigMap.put("Handler", this.codeGeneratorProperty.getParent() + moduleNameName + ".handler");
        injectionConfigMap.put("GroupId", this.codeGeneratorProperty.getGroupId());
        injectionConfigMap.put("Version", this.codeGeneratorProperty.getVersion());
        injectionConfigMap.put("ArtifactId", this.codeGeneratorProperty.getArtifactId());
        injectionConfigMap.put("Mapper", this.codeGeneratorProperty.getParent() + ".infrastructure" + moduleNameName + ".mapper");
        injectionConfigMap.put("PomName", null);
        injectionConfigMap.put("ApiPathPre", StringUtils.isEmpty((CharSequence)this.codeGeneratorProperty.getModuleName()) ? "" : this.codeGeneratorProperty.getModuleName() + "/");
        return injectionConfigMap;
    }
}

