/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.extend;

import cn.airfei.aircore.core.properties.AirCoreProperty;
import cn.airfei.aircore.core.storage.Pojo.LogForMongoDbPojo;
import cn.airfei.aircore.core.storage.bo.TokenBo;
import cn.airfei.aircore.core.utils.EncryptionUtil;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ParseHeaderAuthorization {
    @Resource
    private AirCoreProperty airCoreProperty;

    public TokenBo parse() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (this.airCoreProperty.isPermitParseToken()) {
            String token = request.getHeader("Authorization");
            if (StringUtils.isEmpty((CharSequence)token)) {
                return null;
            }
            if (!StringUtils.isEmpty((CharSequence)(token = token.replace("Bearer ", ""))) && token.length() >= 24) {
                try {
                    String desToken = EncryptionUtil.desEncrypt(token, this.airCoreProperty.getEncryptKey(), this.airCoreProperty.getEncryptIv());
                    return (TokenBo)JSONObject.parseObject((String)desToken, TokenBo.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public LogForMongoDbPojo setLoginInfo(LogForMongoDbPojo logForMongoDbPojo) {
        TokenBo tokenBo = this.parse();
        if (tokenBo == null) {
            return logForMongoDbPojo;
        }
        logForMongoDbPojo.setUserId(tokenBo.getUserId());
        logForMongoDbPojo.setUsername(tokenBo.getUsername());
        logForMongoDbPojo.setNickname(tokenBo.getNickname());
        logForMongoDbPojo.setPlatFormId(tokenBo.getPlatFormId());
        logForMongoDbPojo.setMobile(tokenBo.getMobile());
        logForMongoDbPojo.setUuid(tokenBo.getUuid());
        logForMongoDbPojo.setExpirationTime(tokenBo.getExpirationTime());
        return logForMongoDbPojo;
    }

    public Long getLoginUserId() {
        TokenBo tokenBo = this.parse();
        if (tokenBo != null) {
            return tokenBo.getUserId();
        }
        return null;
    }

    public String getLoginUserName() {
        TokenBo tokenBo = this.parse();
        if (tokenBo != null) {
            return tokenBo.getUsername();
        }
        return null;
    }

    public Long getLoginMobile() {
        TokenBo tokenBo = this.parse();
        if (tokenBo != null) {
            return tokenBo.getMobile();
        }
        return null;
    }
}

