package ${ServiceImpl};

import ${Convertor}.${entity}Convertor;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import ${DomainServiceImpl}.${entity}DomainServiceImpl;
import ${Entity}.${table.entityName};
import ${Dto}.${entity}Dto;
import ${Vo}.${entity}Vo;
import ${Service}.I${entity}Service;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import cn.airfei.aircore.core.storage.PageParam;
import cn.airfei.aircore.core.enums.RespEnum;
import cn.airfei.aircore.core.exception.AppException;
import cn.airfei.aircore.core.utils.QueryParamUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

/**
 * <p>
 * ${table.comment!}
 * </p>
 *
 * @author ${author}
 * @since ${date}
 */
@Service
<#if kotlin>
open class ${entity}ServiceImpl : ${superServiceImplClass}<${table.mapperName}, ${entity}>(), ${table.serviceName} {

}
<#else>
public class ${entity}ServiceImpl implements I${entity}Service {
    @Resource
    private ${entity}Convertor ${entity?uncap_first}Convertor;

    @Resource
    private ${entity}DomainServiceImpl ${entity?uncap_first}DomainService;

    /**
     *
     * @param ${entity?uncap_first}Dto
     * @param pageParam
     * @return
     */
    @Override
    public Page<${entity}Vo> index(${entity}Dto ${entity?uncap_first}Dto,PageParam pageParam) {
        return ${entity?uncap_first}DomainService.index(${entity?uncap_first}Dto,pageParam);
    }

    /**
     * 分页查询单表数据
     *
     * @param map
     * @return
     */
    @Override
    public Page<${entity}Vo> singleTablePage(Map<String, Object> map) {
        Page<${entity}> ${entity?uncap_first}Page=${entity?uncap_first}DomainService.singleTablePage(map);
        List<${entity}Vo> ${entity?uncap_first}VoList = ${entity?uncap_first}Convertor.entityList2VoList(${entity?uncap_first}Page.getRecords());
        Page ${entity?uncap_first}VoPage = ${entity?uncap_first}Page;
        ${entity?uncap_first}VoPage.setRecords(${entity?uncap_first}VoList);
        return ${entity?uncap_first}VoPage;
    }

    /**
     * 显示单条数据
     *
     * @param id
     * @return
     */
    @Override
    public ${entity}Vo show(String id){
        ${entity} ${entity?uncap_first} = ${entity?uncap_first}DomainService.show(id);
        return ${entity?uncap_first}Convertor.entity2Vo(${entity?uncap_first});
    }

    /**
     * 删除（销毁表数据）
     *
     * @param ids
     * @return
     */
    @Override
    public Integer destroy(String ids){
        return ${entity?uncap_first}DomainService.destroy(ids);
    }

    /**
     * 更新表数据
     * @param ${entity?uncap_first}Dto
     * @return
     */
    @Override
    public Integer update(${entity}Dto ${entity?uncap_first}Dto){
        Integer res = ${entity?uncap_first}DomainService.update(${entity?uncap_first}Convertor.dto2Entity(${entity?uncap_first}Dto));
        if (res < 1) {
            throw new AppException(RespEnum.UPDATE_FAIL.getCode(), RespEnum.UPDATE_FAIL.getMsg());
        }
        return res;
    }

    /**
     * 保存表数据
     *
     * @param {entity?uncap_first}Dto
     * @return
     */
    @Override
    public Integer store(${entity}Dto ${entity?uncap_first}Dto){
        return ${entity?uncap_first}DomainService.store(${entity?uncap_first}Convertor.dto2Entity(${entity?uncap_first}Dto));
    }

    /**
     * 设置状态，1:正常,2:禁用/待审核，-1:已删除
     *
     * @param id
     * @param status
     * @return
     */
    @Override
    public boolean setStatus(<#list table.fields as field><#if field.keyFlag>${field.propertyType}</#if></#list> id, Integer status) {
        if(${entity?uncap_first}DomainService.setStatus(id,status)>0){
            return true;
        }
        throw new AppException(RespEnum.SET_STATUS_ERROR.getCode(),RespEnum.SET_STATUS_ERROR.getMsg());
    }

    /**
     * get all resource in storage
     *
     * @return
     */
    @Override
    public List<${entity}Vo> getList(Map<String,Object> map) {
        QueryWrapper<${entity}> queryWrapper = QueryParamUtil.getEntityWrapper(map, ${entity}.class);
        return ${entity?uncap_first}Convertor.entityList2VoList(${entity?uncap_first}DomainService.list(queryWrapper));
    }

    /**
     * 更新多条数据（主键id必传）
     *
     * @return
     */
    @Override
    public List<${entity}Vo> updateBatch(List<${entity}Dto> ${entity?uncap_first}DtoList){
        List<${entity}> ${entity?uncap_first}List = ${entity?uncap_first}Convertor.dtoList2EntityList(${entity?uncap_first}DtoList);
        ${entity?uncap_first}DomainService.updateBatchById(${entity?uncap_first}List);
        return ${entity?uncap_first}Convertor.entityList2VoList(${entity?uncap_first}List);
    }

     /**
      * 添加多条数据
      *
      * @return
      */
    @Override
    public List<${entity}Vo> saveBatch(List<${entity}Dto> ${entity?uncap_first}DtoList){
        List<${entity}> ${entity?uncap_first}List = ${entity?uncap_first}Convertor.dtoList2EntityList(${entity?uncap_first}DtoList);
        ${entity?uncap_first}DomainService.saveBatch(${entity?uncap_first}List);
        return ${entity?uncap_first}Convertor.entityList2VoList(${entity?uncap_first}List);
    }


}
</#if>
