package cn.airfei.aircore.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

/**
 * @description:
 * @author: air
 * @create: 2020-11-04 09:22
 */
public class CollectionUtil {

    /**
     * 判断对象是否为空,并且判断对象所有值是否为空(静态变量除外)
     *
     * @param obj
     * @return
     */
    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return checkObjFieldIsNull(obj);
    }


    /**
     * 判对象字段是否为空,静态变量除外
     *
     * @param obj
     * @return
     */
    private static boolean checkObjFieldIsNull(Object obj) {
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                // 过滤静态变量
                if (f.get(obj) != null && !Modifier.isStatic(f.getModifiers())) {
                    return false;
                }
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}