package cn.airfei.aircore.core.storage.bo;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户表
 * </p>
 *
 * @author air
 * @since 2020-03-17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class UserBo implements Serializable {

    private Long id;
    /**
     * 平台id
     */
    private Integer platformId;

    /**
     * 用户名
     */
    private String username;

    /**
     * 用户昵称
     */
    private String nickname;


    /**
     * 用户手机号
     */
    private Long mobile;

    /**
     * 状态：1:正常,2:禁用，-1:已删除
     */
    private Integer status;

    /**
     * 备注信息
     */
    private String remark;

    /**
     * 用户头像
     */
    private String avatar;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    /**
     * 平台名称
     */
    private  String platformName;


}
