package ${Api};

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import cn.airfei.aircore.core.storage.PageParam;
import ${Dto}.${entity}Dto;
import ${Vo}.${entity}Vo;
import cn.airfei.aircore.core.common.Resp;
import java.util.Map;
import java.util.List;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>


/**
 * <p>
 * ${table.comment!}
 * </p>
 *
 * @author ${author}
 * @version v1.0
 * @since ${date}
 */
@Tag(name = "${table.comment!}", description = "${entity} ${table.comment!}")
<#if kotlin>
class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
<#if superControllerClass??>
public interface ${entity}Api extends ${superControllerClass} {
<#else>
public interface ${entity}Api {
</#if>

    @Operation(description = "分页查询（主要针对多表查询），分页参数：{pageCurrent:当前页(必传)，pageSize:分页大小(必传)}")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<Page<${entity}Vo>> index(@Validated ${entity}Dto ${entity?uncap_first}Dto, BindingResult bindingResult, PageParam pageParam);

    @Operation(description = "查询${table.comment!}列表,只查询单表数据，不关联任何表," +
            "列表(qp-参数支持的操作符号有: eq(=),ne(!=),gt(>),lt(<),ge(>=),le(<=),in,like,notLike,likeleft(左边LIKE '%xxx'),likeright(右边LIKE 'xx%'))")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    @Parameters({
    <#list table.fields as field>
        <#if field.propertyType == "LocalDateTime">
            @Parameter(name = "qp-${field.propertyName}-gt", description = "${field.comment}"),
            @Parameter(name = "qp-${field.propertyName}-le", description = "${field.comment}"),
        <#else >
            @Parameter(name = "qp-${field.propertyName}-eq", description = "${field.comment}"),
        </#if>

    </#list>
            @Parameter(name = "pageCurrent",description = "当前页",  required = true),
            @Parameter(name = "pageSize",description = "分页大小",  required = true)
    })
    Resp<Page<${entity}Vo>> singleTablePage(@RequestParam @Parameter(hidden = true) Map<String,Object> map);

    @Operation(description = "Display the specified resource.")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<${entity}Vo> show(@PathVariable("id") String id);

    @Operation(description = "Store a newly created resource in storage.")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<Integer> store(@RequestBody ${entity}Dto ${entity?uncap_first}Dto);

    @Operation(description = " 支持批量删除，以英文逗号（,） 分割")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<Integer> destroy(@PathVariable("ids") String ids);

    @Operation(description = "Update the specified resource in storage.")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<Integer> update(@RequestBody ${entity}Dto ${entity?uncap_first}Dto);

    @Operation(description = "设置状态，1:正常,2:禁用/待审核，-1:已删除")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<Boolean> setStatus(<#list table.fields as field><#if field.keyFlag>${field.propertyType}</#if></#list> id,Integer status);

    @Operation(description = "查询${table.comment!}列表(不分页),(qp-参数支持的操作符号有: eq(=),ne(!=),gt(>),lt(<),ge(>=),le(<=),in,like,notLike,likeleft(左边LIKE '%xxx'),likeright(右边LIKE 'xx%'))")
    @Parameters({
     <#list table.fields as field>
         <#if field.propertyType == "LocalDateTime">
             @Parameter(name = "qp-${field.propertyName}-gt", description = "${field.comment}"),
             @Parameter(name = "qp-${field.propertyName}-le", description = "${field.comment}"),
         <#else >
             @Parameter(name = "qp-${field.propertyName}-eq", description = "${field.comment}"),
         </#if>
     </#list>
     })
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<List<${entity}Vo>> getList(@RequestParam @Parameter(hidden = true) Map<String,Object> map);

    @Operation(description = "添加多条数据")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<List<${entity}Vo>> saveBatch(@RequestBody List<${entity}Dto> ${entity?uncap_first}DtoList);

    @Operation(description = "更新多条数据（主键id必传）")
    @ApiResponses(value = {@ApiResponse(responseCode = "0", description = "0:成功，否则失败")})
    Resp<List<${entity}Vo>> updateBatch(@RequestBody List<${entity}Dto> ${entity?uncap_first}DtoList);

}
</#if>
