package ${cfg.Config};

import cn.airfei.aircore.core.aspect.AllControllerLogAspect;
import cn.airfei.aircore.core.beans.Error;
import cn.airfei.aircore.core.handler.MyMetaObjectHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import cn.airfei.aircore.core.aspect.AllControllerLogAspect;
import org.springframework.http.HttpHeaders;
import cn.airfei.aircore.core.extend.InsertLogToMongoDb;

/**
 *
 * @author ${author}
 * @version v1.0
 * @since ${date}
 */
@Configuration
public class AirCoreConfig {

    /**
     * 统一异常抛出
     * @return
     */
    @Bean
    public Error error(){
        return new Error();
    }


    /**
     * mybatis plus 自动填充数据
     * @return
     */
    @Bean
    public MyMetaObjectHandler myMetaObjectHandler(){
        return new MyMetaObjectHandler();
    }


    /**
     * 设置请求头
     * @return
    */
    @Bean
    public  HttpHeaders httpHeaders(){
        return new HttpHeaders();
    }


    /**
     * 日志aop
     * @return
    */
    @Bean
    public AllControllerLogAspect allControllerLogAspect(){
        return new AllControllerLogAspect();
    }


    /**
     * 配置写日志到mongoDb(controller层)
     * 会记录请求参数和返回结果等
     * 需要在配置文件中配置: air.code.setLogToMongoDb=true (默认false)
     * @return
    */
    @Bean
    public InsertLogToMongoDb insertLogToMongoDb(){
        return new InsertLogToMongoDb();
    }


}
