package cn.airfei.aircore.core.annotations;


import java.lang.annotation.*;

/**
 * 利用redisson 添加分布式锁
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RedissonLock {

    /**
     * 锁的字段,获取参数中字段的值作为锁的名称,用于精确控制,防止前端恶意传传参
     * 如:可指定商品id,或库存id 等等,一般用于防止超发等
     * <p>
     * lockName=md5(method+url+lockFieldsValue)
     *
     * @return
     */
    String lockFields() default "";

    /**
     * 是否要指定锁名(key)，开启后会忽略lockFields字段等
     * 即：开启后，对整个方法加锁，因此：开启后会大大降低性能
     * 默认""（关闭）
     *
     * @return
     */
    String lockKey() default "";

}
