/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.config;

import cn.airfei.aircore.core.extend.InsertLogToMongoDb;
import cn.airfei.aircore.core.extend.ParseHeaderAuthorization;
import cn.airfei.aircore.core.properties.AirCoreProperty;
import cn.airfei.aircore.core.storage.Pojo.LogForMongoDbPojo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import feign.FeignException;
import feign.Logger;
import feign.RequestInterceptor;
import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FeignLoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignClientConfig {
    @Resource
    private AirCoreProperty airCoreProperty;
    @Resource
    private InsertLogToMongoDb insertLogToMongoDb;
    @Resource
    private ParseHeaderAuthorization parseHeaderAuthorization;

    @Bean
    Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    public RequestInterceptor headerInterceptor() {
        return requestTemplate -> {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                String traceId = String.valueOf(request.getAttribute("traceId"));
                requestTemplate.header("traceId", new String[]{traceId});
                if (requestTemplate.headers().get("Authorization") == null && !StringUtils.isEmpty((CharSequence)request.getHeader("Authorization"))) {
                    requestTemplate.header("Authorization", new String[]{request.getHeader("Authorization")});
                }
                if (requestTemplate.headers().get("token") == null && !StringUtils.isEmpty((CharSequence)request.getHeader("token"))) {
                    requestTemplate.header("token", new String[]{request.getHeader("token")});
                }
                if (request.getParameter("pageSize") != null) {
                    requestTemplate.query("pageSize", new String[]{request.getParameter("pageSize")});
                }
                if (request.getParameter("pageCurrent") != null) {
                    requestTemplate.query("pageCurrent", new String[]{request.getParameter("pageCurrent")});
                }
                HashMap<String, Object> paraMap = new HashMap<String, Object>();
                if (requestTemplate.body() != null) {
                    paraMap.put("paramBody", new String(requestTemplate.body()));
                }
                paraMap.put("paramPath", requestTemplate.queries());
                if (this.airCoreProperty.getSetLogToMongoDb().booleanValue()) {
                    LogForMongoDbPojo logForMongoDbPojo = new LogForMongoDbPojo();
                    logForMongoDbPojo.setCreateTime(LocalDateTime.now());
                    logForMongoDbPojo.setUrl(requestTemplate.feignTarget().url() + requestTemplate.url());
                    logForMongoDbPojo.setTraceId(traceId);
                    logForMongoDbPojo.setMethod(requestTemplate.method());
                    logForMongoDbPojo.setParams(paraMap);
                    logForMongoDbPojo.setRemark("feign request");
                    logForMongoDbPojo.setToken(request.getHeader("token"));
                    logForMongoDbPojo.setAuthorization(request.getHeader("Authorization"));
                    this.parseHeaderAuthorization.setLoginInfo(logForMongoDbPojo);
                    this.insertLogToMongoDb.insertLog(logForMongoDbPojo);
                }
            }
        };
    }

    @Bean
    public FeignResultDecoder feignResultDecoder() {
        return new FeignResultDecoder();
    }

    @Bean
    FeignLoggerFactory infoFeignLoggerFactory() {
        return new FeignLoggerFactoryImpl();
    }

    public class FeignResultDecoder
    implements Decoder {
        public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
            Response.Body body = response.body();
            String bodyStr = Util.toString((Reader)body.asReader(Util.UTF_8));
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                if (FeignClientConfig.this.airCoreProperty.getSetLogToMongoDb().booleanValue()) {
                    LogForMongoDbPojo logForMongoDbPojo = new LogForMongoDbPojo();
                    logForMongoDbPojo.setCreateTime(LocalDateTime.now());
                    logForMongoDbPojo.setUrl(response.request().url());
                    logForMongoDbPojo.setTraceId(String.valueOf(request.getAttribute("traceId")));
                    logForMongoDbPojo.setMethod(String.valueOf(response.request().httpMethod()));
                    logForMongoDbPojo.setResult(JSON.parseObject((String)bodyStr, (Type)type, (Feature[])new Feature[0]));
                    logForMongoDbPojo.setRemark("feign result");
                    logForMongoDbPojo.setToken(request.getHeader("token"));
                    logForMongoDbPojo.setAuthorization(request.getHeader("Authorization"));
                    FeignClientConfig.this.parseHeaderAuthorization.setLoginInfo(logForMongoDbPojo);
                    FeignClientConfig.this.insertLogToMongoDb.insertLog(logForMongoDbPojo);
                }
            }
            if (String.class.equals((Object)type)) {
                return bodyStr;
            }
            return JSON.parseObject((String)bodyStr, (Type)type, (Feature[])new Feature[0]);
        }
    }

    private static class InfoFeignLogger
    extends feign.Logger {
        private Logger logger;

        public InfoFeignLogger(Logger logger) {
            this.logger = logger;
        }

        protected void log(String configKey, String format, Object ... objects) {
            if (this.logger.isInfoEnabled()) {
                String str = String.format(InfoFeignLogger.methodTag((String)configKey) + format, objects);
                this.logger.info(str);
            }
        }
    }

    private static class FeignLoggerFactoryImpl
    implements FeignLoggerFactory {
        private FeignLoggerFactoryImpl() {
        }

        public feign.Logger create(Class<?> type) {
            return new InfoFeignLogger(LoggerFactory.getLogger(type));
        }
    }
}

