/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.common;

import cn.airfei.aircore.core.enums.RespEnum;
import java.io.Serializable;

public class Resp<T>
implements Serializable {
    private Integer code;
    private String msg;
    private String traceId;
    private String appId;
    private T data;

    private Resp(T data, Integer code, String msg) {
        this.msg = msg;
        this.data = data;
        this.code = code;
    }

    private Resp(Integer code, String msg) {
        this.msg = msg;
        this.data = null;
        this.code = code;
    }

    private Resp(Integer code, String msg, String traceId) {
        this.msg = msg;
        this.data = null;
        this.code = code;
        this.traceId = traceId;
    }

    private Resp(T data) {
        this.data = data;
        this.msg = RespEnum.SUCCESS.getMsg();
        this.code = RespEnum.SUCCESS.getCode();
    }

    private Resp() {
        this.data = null;
        this.msg = RespEnum.SUCCESS.getMsg();
        this.code = RespEnum.SUCCESS.getCode();
    }

    public static <T> Resp<T> response(T data, Integer code, String msg) {
        return new Resp<T>(data, code, msg);
    }

    public static <T> Resp<T> response(Integer code, String msg) {
        return new Resp<T>(code, msg);
    }

    public static <T> Resp<T> response(Integer code, String msg, String traceId) {
        return new Resp<T>(code, msg, traceId);
    }

    public static <T> Resp<T> response(T data) {
        return new Resp<T>(data);
    }

    public static <T> Resp<T> response() {
        return new Resp<T>();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getAppId() {
        return this.appId;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resp)) {
            return false;
        }
        Resp other = (Resp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Resp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Resp(code=" + this.getCode() + ", msg=" + this.getMsg() + ", traceId=" + this.getTraceId() + ", appId=" + this.getAppId() + ", data=" + this.getData() + ")";
    }
}

