/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.aspect;

import cn.airfei.aircore.core.common.Resp;
import cn.airfei.aircore.core.exception.AppException;
import cn.airfei.aircore.core.extend.InsertLogToMongoDb;
import cn.airfei.aircore.core.extend.ParseHeaderAuthorization;
import cn.airfei.aircore.core.properties.AirCoreProperty;
import cn.airfei.aircore.core.storage.Pojo.LogForMongoDbPojo;
import cn.airfei.aircore.core.utils.CollectionUtil;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
@Order(value=1)
public class AllControllerLogAspect {
    private static final Logger log = LoggerFactory.getLogger(AllControllerLogAspect.class);
    @Resource
    private AirCoreProperty airCoreProperty;
    @Resource
    private InsertLogToMongoDb insertLogToMongoDb;
    @Resource
    private ParseHeaderAuthorization parseHeaderAuthorization;

    @Pointcut(value="execution(* *..controller.*..*(..))")
    public void log() {
    }

    @Before(value="log()")
    public void before(JoinPoint jp) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        String name = jp.getSignature().getName();
        log.info("*****************[" + jp.getSignature().getDeclaringTypeName() + "." + name + "]\u65b9\u6cd5\u5f00\u59cb\u6267\u884c*****************");
        log.info("[\u8bf7\u6c42IP]:{}", (Object)request.getRemoteAddr());
        log.info("[\u8bf7\u6c42URL]:{}", (Object)request.getRequestURL());
        log.info("[URL\u53c2\u6570]:{}", (Object)request.getQueryString());
        log.info("[\u8bf7\u6c42\u65b9\u5f0f]:{}", (Object)request.getMethod());
        HashMap<String, Object> argList = new HashMap<String, Object>();
        ArrayList<Object> bodyList = new ArrayList<Object>();
        for (Object arg : jp.getArgs()) {
            if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse || arg instanceof BeanPropertyBindingResult) continue;
            if (arg instanceof MultipartFile) {
                MultipartFile multipartFile = (MultipartFile)arg;
                bodyList.add(multipartFile.getName() + ":" + multipartFile.getOriginalFilename());
                bodyList.add("fileSize:" + multipartFile.getSize());
                continue;
            }
            if (CollectionUtil.isEmpty(arg)) continue;
            bodyList.add(arg);
        }
        argList.put("paramBody", bodyList);
        Map parameterMap = request.getParameterMap();
        if (parameterMap.size() > 0) {
            argList.put("paramPath", parameterMap);
        }
        log.info("[\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570]:{}", (Object)JSON.toJSONString(argList));
        if (this.airCoreProperty.getSetLogToMongoDb().booleanValue()) {
            String url = String.valueOf(request.getRequestURL());
            if (!StringUtils.isEmpty((CharSequence)request.getQueryString())) {
                url = url + "?" + request.getQueryString();
            }
            LogForMongoDbPojo logForMongoDbPojo = new LogForMongoDbPojo();
            logForMongoDbPojo.setParams(argList);
            logForMongoDbPojo.setCreateTime(LocalDateTime.now());
            logForMongoDbPojo.setUrl(url);
            logForMongoDbPojo.setTraceId(String.valueOf(request.getAttribute("traceId")));
            logForMongoDbPojo.setIp(request.getRemoteAddr());
            logForMongoDbPojo.setMethod(request.getMethod());
            logForMongoDbPojo.setAuthorization(request.getHeader("Authorization"));
            this.parseHeaderAuthorization.setLoginInfo(logForMongoDbPojo);
            this.insertLogToMongoDb.insertLog(logForMongoDbPojo);
        }
    }

    @After(value="log()")
    public void after(JoinPoint jp) {
        String name = jp.getSignature().getName();
    }

    @AfterReturning(value="log()", returning="result")
    public void afterReturning(JoinPoint jp, Object result) {
        String name = jp.getSignature().getName();
        log.info("[\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9]:{}", (Object)JSON.toJSONString((Object)result));
        log.info("*****************[" + jp.getSignature().getDeclaringTypeName() + "." + name + "]\u65b9\u6cd5\u6267\u884c\u7ed3\u675f*****************");
    }

    @AfterThrowing(value="log()", throwing="e")
    public void afterThrowing(JoinPoint jp, Exception e) {
        String name = jp.getSignature().getName();
        log.error("[" + jp.getSignature().getDeclaringTypeName() + "." + name + "]\u65b9\u6cd5\u629b\u5f02\u5e38\u4e86\uff0c\u5f02\u5e38\u662f\uff1a" + e.getMessage());
    }

    @Around(value="log()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        long start = System.currentTimeMillis();
        Object result = null;
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            result = jp.proceed();
            long end = System.currentTimeMillis();
            log.info("[\u65b9\u6cd5\u6267\u884c\u65f6\u95f4]:" + (end - start) + " ms");
            Resp resp = (Resp)result;
            resp.setTraceId(String.valueOf(request.getAttribute("traceId")));
            if (this.airCoreProperty.getSetLogToMongoDb().booleanValue()) {
                LogForMongoDbPojo logForMongoDbPojo = new LogForMongoDbPojo();
                String url = String.valueOf(request.getRequestURL());
                if (!StringUtils.isEmpty((CharSequence)request.getQueryString())) {
                    url = url + "?" + request.getQueryString();
                }
                logForMongoDbPojo.setResult(resp);
                logForMongoDbPojo.setCreateTime(LocalDateTime.now());
                logForMongoDbPojo.setTraceId(String.valueOf(request.getAttribute("traceId")));
                logForMongoDbPojo.setUrl(url);
                logForMongoDbPojo.setIp(request.getRemoteAddr());
                logForMongoDbPojo.setMethod(request.getMethod());
                logForMongoDbPojo.setExecuteTime(end - start + "ms");
                logForMongoDbPojo.setAuthorization(request.getHeader("Authorization"));
                this.parseHeaderAuthorization.setLoginInfo(logForMongoDbPojo);
                this.insertLogToMongoDb.insertLog(logForMongoDbPojo);
            }
            return resp;
        }
        catch (AppException e) {
            throw new AppException(e.getCode(), e.getMessage());
        }
    }
}

