package ${Api};

import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import cn.airfei.aircore.core.storage.PageParam;
import ${Dto}.${entity}Dto;
import ${Vo}.${entity}Vo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import cn.airfei.aircore.core.common.Resp;
import java.util.Map;
import java.util.List;
import springfox.documentation.annotations.ApiIgnore;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>


/**
 * <p>
 * ${table.comment!}
 * </p>
 *
 * @author ${author}
 * @version v1.0
 * @since ${date}
 */
@Api(value = "${table.comment!}", tags = {"${entity} ${table.comment!}"})
<#if kotlin>
class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
<#if superControllerClass??>
public interface ${entity}Api extends ${superControllerClass} {
<#else>
public interface ${entity}Api {
</#if>

    @ApiOperation(value = "分页查询（主要针对多表查询），分页参数：{pageCurrent:当前页(必传)，pageSize:分页大小(必传)}")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = Resp.class)})
    Resp<Page<${entity}Vo>> index(@Validated ${entity}Dto ${entity?uncap_first}Dto, BindingResult bindingResult, PageParam pageParam);

    @ApiOperation(value = "查询${table.comment!}列表,只查询单表数据，不关联任何表," +
            "列表(qp-参数支持的操作符号有: eq(=),ne(!=),gt(>),lt(<),ge(>=),le(<=),in,like,notLike,likeleft(左边LIKE '%xxx'),likeright(右边LIKE 'xx%'))")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = ${entity}Dto.class)})
    @ApiImplicitParams({
    <#list table.fields as field>
        <#if field.propertyType == "LocalDateTime">
            @ApiImplicitParam(name = "qp-${field.propertyName}-gt", value = "${field.comment}", paramType = "query", dataType="date"),
            @ApiImplicitParam(name = "qp-${field.propertyName}-le", value = "${field.comment}", paramType = "query", dataType="date"),
        <#else >
            @ApiImplicitParam(name = "qp-${field.propertyName}-eq", value = "${field.comment}", paramType = "query" ),
        </#if>

    </#list>
            @ApiImplicitParam(name = "pageCurrent",value = "当前页", paramType = "query", dataType = "long", defaultValue = "1", required = true),
            @ApiImplicitParam(name = "pageSize",value = "分页大小", paramType = "query", dataType = "long", defaultValue = "15", required = true)
    })
    Resp<Page<${entity}Vo>> singleTablePage(@ApiIgnore @RequestParam Map<String,Object> map);

    @ApiOperation(value = "Display the specified resource.")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败")})
    Resp<${entity}Vo> show(@PathVariable("id") String id);

    @ApiOperation(value = "Store a newly created resource in storage.")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败", response = Resp.class)})
    Resp<Integer> store(@RequestBody ${entity}Dto ${entity?uncap_first}Dto);

    @ApiOperation(value = " 支持批量删除，以英文逗号（,） 分割")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败")})
    Resp<Integer> destroy(@PathVariable("ids") String ids);

    @ApiOperation(value = "Update the specified resource in storage.")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = Resp.class)})
    Resp<Integer> update(@RequestBody ${entity}Dto ${entity?uncap_first}Dto);

    @ApiOperation(value = "设置状态，1:正常,2:禁用/待审核，-1:已删除")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = Resp.class)})
    Resp<Boolean> setStatus(<#list table.fields as field><#if field.keyFlag>${field.propertyType}</#if></#list> id,Integer status);

    @ApiOperation(value = "查询${table.comment!}列表(不分页),(qp-参数支持的操作符号有: eq(=),ne(!=),gt(>),lt(<),ge(>=),le(<=),in,like,notLike,likeleft(左边LIKE '%xxx'),likeright(右边LIKE 'xx%'))")
    @ApiImplicitParams({
     <#list table.fields as field>
         <#if field.propertyType == "LocalDateTime">
             @ApiImplicitParam(name = "qp-${field.propertyName}-gt", value = "${field.comment}", paramType = "query", dataType="date"),
             @ApiImplicitParam(name = "qp-${field.propertyName}-le", value = "${field.comment}", paramType = "query", dataType="date"),
         <#else >
             @ApiImplicitParam(name = "qp-${field.propertyName}-eq", value = "${field.comment}", paramType = "query" ),
         </#if>
     </#list>
     })
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = Resp.class)})
    Resp<List<${entity}Vo>> getList(@ApiIgnore @RequestParam Map<String,Object> map);

    @ApiOperation(value = "添加多条数据")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = Resp.class)})
    Resp<List<${entity}Vo>> saveBatch(@RequestBody List<${entity}Dto> ${entity?uncap_first}DtoList);

    @ApiOperation(value = "更新多条数据（主键id必传）")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = Resp.class)})
    Resp<List<${entity}Vo>> updateBatch(@RequestBody List<${entity}Dto> ${entity?uncap_first}DtoList);

}
</#if>
