package cn.airfei.aircore.core.utils;

import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * @description:
 * @author: air
 * @create: 2021-01-21 13:45
 */
@Component
public class RedisUtil {

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 设置key和value ,当key存在时返回false
     *
     * @param key
     * @param value
     * @return
     */
    public boolean setIfAbsent(String key, String value) {
        return stringRedisTemplate.opsForValue().setIfAbsent(key, value);
    }

    /**
     * 设置key和value ,当key存在时返回false
     *
     * @param key
     * @param value
     * @param seconds 过期时间 秒
     * @return
     */
    public boolean setIfAbsent(String key, String value, Long seconds) {
        return stringRedisTemplate.opsForValue().setIfAbsent(key, value, Duration.ofSeconds(seconds));
    }

    public boolean setIfAbsent(String key, String value, Long time, TimeUnit timeUnit) {
        return stringRedisTemplate.opsForValue().setIfAbsent(key, value, time, timeUnit);
    }

    /**
     * 设置key和value
     *
     * @param key
     * @param value
     */
    public void set(String key, String value) {
        stringRedisTemplate.opsForValue().set(key, value);
    }

    /**
     * 设置key和value并设置过期时间
     *
     * @param key
     * @param value
     * @param duration
     */
    public void set(String key, String value, Duration duration) {
        stringRedisTemplate.opsForValue().set(key, value, duration);
    }

    /**
     * @param key
     * @param value
     * @param duration 过期时间 秒
     */
    public void set(String key, String value, Long duration) {
        stringRedisTemplate.opsForValue().set(key, value, Duration.ofSeconds(duration));
    }


    /**
     * 设置key的值并设置过期时间
     *
     * @param key
     * @param value
     * @param timeOut
     * @param utils
     */
    public void set(String key, String value, Long timeOut, TimeUnit utils) {
        stringRedisTemplate.opsForValue().set(key, value, timeOut, utils);
    }

    /**
     * 设置key 的过期时间
     *
     * @param key
     * @param timeOut
     * @param units
     * @return
     */
    public boolean expire(String key, Long timeOut, TimeUnit units) {
        return stringRedisTemplate.expire(key, timeOut, units);
    }

    /**
     * 通过key获取值
     *
     * @param key
     * @return
     */
    public String get(String key) {
        return stringRedisTemplate.opsForValue().get(key);
    }

    /**
     * 删除key
     *
     * @param key
     * @return
     */
    public boolean remove(String key) {
        return stringRedisTemplate.opsForValue().getOperations().delete(key);
    }

    /**
     * 删除key,当key不存在时返回false
     *
     * @param key
     * @return
     */
    public boolean delete(String key) {
        return stringRedisTemplate.delete(key);
    }

    /**
     * 查账出key,允许通配符：*，?，[]
     *
     * @param pattern eg. *air*
     * @return
     */
    public Set<String> keys(String pattern) {
        return stringRedisTemplate.keys(pattern);
    }
}
