package ${package.Controller};

import ${Api}.${entity}Api;
import org.springframework.web.bind.annotation.*;
import ${ServiceImpl}.${entity}ServiceImpl;
import ${Dto}.${entity}Dto;
import ${Vo}.${entity}Vo;
import cn.airfei.aircore.core.common.Resp;
import cn.airfei.aircore.core.storage.PageParam;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import java.util.Map;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import javax.annotation.Resource;
import springfox.documentation.annotations.ApiIgnore;
import cn.airfei.aircore.core.enums.RespEnum;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
<#if restControllerStyle>
import org.springframework.web.bind.annotation.RestController;
<#else>
import org.springframework.stereotype.Controller;
</#if>
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>

/**
 * <p>
 * ${table.comment!}
 * </p>
 *
 * @author ${author}
 * @version v1.0
 * @since ${date}
 */
<#if restControllerStyle>
@RestController
@Slf4j
<#else>
@Controller
</#if>
@RequestMapping("${ApiPathPre}${table.entityPath}")
<#if kotlin>
class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
<#if superControllerClass??>
public class ${table.controllerName} extends ${superControllerClass} {
<#else>
public class ${table.controllerName} implements ${entity}Api {
</#if>
    @Resource
    private ${entity}ServiceImpl ${entity?uncap_first}Service;


    /**
     * display a listing of the resource.
     *
     * @param ${entity?uncap_first}Dto
     * @param bindingResult
     * @param pageParam
     * @return
     */
    @Override
    @GetMapping(value = "")
    public Resp<Page<${entity}Vo>> index(@Validated ${entity}Dto ${entity?uncap_first}Dto, BindingResult bindingResult, PageParam pageParam){
        if (bindingResult.hasErrors()){
            return Resp.response(RespEnum.PARAM_VALID_ERROR.getCode(), RespEnum.PARAM_VALID_ERROR.getMsg()+bindingResult.getFieldError().getDefaultMessage());
        }
        return Resp.response(${entity?uncap_first}Service.index(${entity?uncap_first}Dto, pageParam));
    }

    /**
     * 只查询单表数据，不关联任何表
     *
     * @param map
     * @return
     */
    @Override
    @GetMapping(value = "singleTablePage")
    public Resp<Page<${entity}Vo>> singleTablePage(@ApiIgnore @RequestParam Map<String,Object> map){
        return Resp.response(${entity?uncap_first}Service.singleTablePage(map));
    }

    /**
     * Display the specified resource.
     *
     * @param id
     * @return
     */
    @Override
    @GetMapping(value = "/{id}")
    public Resp<${entity}Vo> show(@PathVariable("id") String id) {
        return Resp.response(${entity?uncap_first}Service.show(id));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param ${entity?uncap_first}Dto
     * @return
     */
    @Override
    @PostMapping(value = "")
    public Resp<Integer> store(@RequestBody ${entity}Dto ${entity?uncap_first}Dto) {
        return Resp.response(${entity?uncap_first}Service.store(${entity?uncap_first}Dto));
    }

    /**
     * 支持批量删除，以英文逗号（,） 分割
     *
     * @param ids
     * @return
     */
    @Override
    @DeleteMapping(value = "/{ids}")
    public Resp<Integer> destroy(@PathVariable("ids") String ids) {
        return Resp.response(${entity?uncap_first}Service.destroy(ids));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param ${entity?uncap_first}Dto
     * @return
     */
    @Override
    @PutMapping(value = "")
    public Resp<Integer> update(@RequestBody ${entity}Dto ${entity?uncap_first}Dto) {
        return Resp.response(${entity?uncap_first}Service.update(${entity?uncap_first}Dto));
    }

    /**
     * 设置${entity}状态
     * @param id
     * @param status
     * @return
     */
    @Override
    @PutMapping(value = "setStatus")
    public Resp<Boolean> setStatus(<#list table.fields as field><#if field.keyFlag>${field.propertyType}</#if></#list> id, Integer status) {
        return Resp.response(${entity?uncap_first}Service.setStatus(id,status));
    }

    /**
     * get all resource in storage
     * @return
     */
    @Override
    @GetMapping(value = "getList")
    public Resp<List<${entity}Vo>> getList(@ApiIgnore @RequestParam Map<String,Object> map) {
        return Resp.response(${entity?uncap_first}Service.getList(map));
    }

    /**
     * 更新多条数据（主键id必传）
     *
     * @return
     */
    @Override
    @PostMapping(value = "updateBatch")
    public Resp<List<${entity}Vo>> updateBatch(@RequestBody List<${entity}Dto> ${entity?uncap_first}DtoList) {
        return Resp.response(${entity?uncap_first}Service.updateBatch(${entity?uncap_first}DtoList));
    }

    /**
     * 添加多条数据
     *
     * @return
     */
    @Override
    @PostMapping(value = "saveBatch")
    public Resp<List<${entity}Vo>> saveBatch(@RequestBody List<${entity}Dto> ${entity?uncap_first}DtoList) {
        return Resp.response(${entity?uncap_first}Service.saveBatch(${entity?uncap_first}DtoList));
    }

}
</#if>
