/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.aspect;

import cn.airfei.aircore.core.annotations.RedissonLock;
import cn.airfei.aircore.core.exception.AppException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedissonLockAspect {
    private static final Logger log = LoggerFactory.getLogger(RedissonLockAspect.class);
    private static final Integer CODE = 722001;
    private static final String ERROR_MSG = "\u60a8\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41,\u7cfb\u7edf\u5fd9\u4e0d\u8fc7\u6765\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5\u8bd5";
    private static final String ATTRIBUTE_KEY = "air_core_redisson_key_md5";
    @Resource
    private HttpServletRequest httpServletRequest;
    @Resource
    private RedissonClient redissonClient;

    @Pointcut(value="@annotation(cn.airfei.aircore.core.annotations.RedissonLock)")
    public void annotationPointcut() {
    }

    @Before(value="annotationPointcut()")
    public void before(JoinPoint jp) {
        String keyMd5 = this.setRedisKeyMd5(jp);
        RLock lock = this.redissonClient.getLock(keyMd5);
        try {
            boolean tryLock = lock.tryLock(120L, 60L, TimeUnit.SECONDS);
            if (!tryLock) {
                log.warn("\u6210\u529f\u62e6\u622a\u91cd\u590d\u8bf7\u6c42,url:{},method:{},ip:{}", new Object[]{this.httpServletRequest.getRequestURI(), this.httpServletRequest.getMethod(), this.httpServletRequest.getRemoteAddr()});
                throw new AppException(CODE, ERROR_MSG);
            }
        }
        catch (InterruptedException e) {
            log.error("tryLock \u53d1\u751f\u5f02\u5e38\u4e86,{}", (Object)e.getMessage());
            lock.unlock();
            throw new AppException(CODE, e.getMessage());
        }
    }

    @AfterReturning(value="annotationPointcut()", returning="result")
    public void afterReturning(JoinPoint jp, Object result) {
        String keyMd5 = (String)this.httpServletRequest.getAttribute(ATTRIBUTE_KEY);
        RLock lock = this.redissonClient.getLock(keyMd5);
        lock.unlock();
    }

    @AfterThrowing(value="annotationPointcut()", throwing="e")
    public void afterThrowing(JoinPoint jp, Exception e) {
        String keyMd5 = (String)this.httpServletRequest.getAttribute(ATTRIBUTE_KEY);
        RLock lock = this.redissonClient.getLock(keyMd5);
        lock.unlock();
    }

    private String setRedisKeyMd5(JoinPoint jp) {
        String[] lockFieldArr;
        RedissonLock redissonLock = ((MethodSignature)jp.getSignature()).getMethod().getAnnotation(RedissonLock.class);
        StringBuilder lockName = new StringBuilder();
        lockName.append(this.httpServletRequest.getMethod());
        lockName.append(this.httpServletRequest.getRequestURL());
        if (!redissonLock.lockKey().equals("")) {
            log.info("lockKey :{}", (Object)redissonLock.lockKey());
            this.httpServletRequest.setAttribute(ATTRIBUTE_KEY, (Object)redissonLock.lockKey());
            return redissonLock.lockKey();
        }
        Object[] objects = jp.getArgs();
        String[] stringArray = lockFieldArr = StringUtils.isNotEmpty((CharSequence)redissonLock.lockFields()) ? redissonLock.lockFields().split(",") : new String[]{};
        if (lockFieldArr.length == 0) {
            lockName.append(Arrays.toString(objects));
        }
        block2: for (String lockField : lockFieldArr) {
            for (Object o : objects) {
                Field[] declaredFields;
                boolean mark = false;
                Class<?> aClass = o.getClass();
                for (Field field : declaredFields = aClass.getDeclaredFields()) {
                    if (!field.getName().equals(lockField)) continue;
                    try {
                        field.setAccessible(true);
                        Object o1 = field.get(o);
                        lockName.append(o1);
                        mark = true;
                        break;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (mark) continue block2;
            }
        }
        String md5Hex = DigestUtils.md5Hex((String)lockName.toString());
        log.info("lockName md5\u7f16\u7801\u524d:{}", (Object)lockName.toString());
        this.httpServletRequest.setAttribute(ATTRIBUTE_KEY, (Object)md5Hex);
        return md5Hex;
    }
}

