/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.aspect;

import cn.airfei.aircore.core.exception.AppException;
import cn.airfei.aircore.core.utils.RedisUtil;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CheckRepeatRequestAspect {
    private static final Logger log = LoggerFactory.getLogger(CheckRepeatRequestAspect.class);
    private static final Integer CODE = 722000;
    private static final String ERROR_MSG = "\u60a8\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41,\u7cfb\u7edf\u5fd9\u4e0d\u8fc7\u6765\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5\u8bd5";
    private static final String ATTRIBUTE_KEY = "air_core_redis_key_md5";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private HttpServletRequest httpServletRequest;

    @Pointcut(value="@annotation(cn.airfei.aircore.core.annotations.CheckRepeatRequest)")
    public void annotationPointcut() {
    }

    @Before(value="annotationPointcut()")
    public void before(JoinPoint jp) {
        String keyMd5 = this.setRedisKeyMd5(jp);
        if (this.redisUtil.get(keyMd5) != null || !this.redisUtil.setIfAbsent(keyMd5, "true", 600L)) {
            log.warn("\u6210\u529f\u62e6\u622a\u91cd\u590d\u8bf7\u6c42,url:{},method:{},ip:{}", new Object[]{this.httpServletRequest.getRequestURI(), this.httpServletRequest.getMethod(), this.httpServletRequest.getRemoteAddr()});
            throw new AppException(CODE, ERROR_MSG);
        }
    }

    @AfterReturning(value="annotationPointcut()", returning="result")
    public void afterReturning(JoinPoint jp, Object result) {
        String keyMd5 = (String)this.httpServletRequest.getAttribute(ATTRIBUTE_KEY);
        this.redisUtil.remove(keyMd5);
    }

    @AfterThrowing(value="annotationPointcut()", throwing="e")
    public void afterThrowing(JoinPoint jp, Exception e) {
        String keyMd5 = (String)this.httpServletRequest.getAttribute(ATTRIBUTE_KEY);
        if (e instanceof AppException) {
            AppException appException = (AppException)e;
            if (!appException.getCode().equals(CODE)) {
                this.redisUtil.remove(keyMd5);
            }
        } else {
            this.redisUtil.remove(keyMd5);
        }
    }

    private String setRedisKeyMd5(JoinPoint jp) {
        StringBuilder tempStr = new StringBuilder();
        tempStr.append(this.httpServletRequest.getRequestURI());
        tempStr.append(this.httpServletRequest.getMethod());
        tempStr.append(this.httpServletRequest.getRemoteAddr());
        Map parameterMap = this.httpServletRequest.getParameterMap();
        for (String key : parameterMap.keySet()) {
            String[] values = (String[])parameterMap.get(key);
            if (values == null || values.length <= 0) continue;
            for (String value : values) {
                tempStr.append(value);
            }
        }
        tempStr.append(Arrays.toString(jp.getArgs()));
        String md5Hex = DigestUtils.md5Hex((String)String.valueOf(tempStr));
        this.httpServletRequest.setAttribute(ATTRIBUTE_KEY, (Object)md5Hex);
        return md5Hex;
    }
}

