package cn.airfei.aircore.core.storage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: air
 * @create: 2020-01-02 09:55
 **/
@Data
@ApiModel(value = "分页参数", description = "分页参数")
public class PageParam implements Serializable {
    @ApiModelProperty(value = "当前页")
    private Long pageCurrent = 1L;

    @ApiModelProperty(value = "分页大小")
    private Long pageSize = 15L;

    @ApiModelProperty(value = "分页大小")
    private Integer total;

    @ApiModelProperty(value = "存储时间字符串")
    private String date;

    @ApiModelProperty(value = "开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss", iso = DateTimeFormat.ISO.DATE_TIME)
    private LocalDateTime startTime;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME, pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间")
    private LocalDateTime endTime;
}
