package cn.airfei.aircore.core.interceptor;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @description:
 * @author: air
 * @create: 2020-11-07 11:24
 */
@Configuration
@Order(0)
public class WebMvcInterceptor implements WebMvcConfigurer {
    @Bean
    AllInterceptor allInterceptor() {
        return new AllInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(allInterceptor())
                .addPathPatterns("/**")
        ;
    }

    @Override
    public void addFormatters(FormatterRegistry registry) {

    }

    @Override
    public void addCorsMappings(CorsRegistry registry) {
    }
}
