package cn.airfei.aircore.core.enums;


/**
 * @description:预定义枚举常量，除SUCCESS外，其他code均以722开头
 * @author: air
 * @create: 2019-07-16 14:00
 **/
public enum RespEnum {
    SUCCESS(0, "success"),

    TOKEN_ERROR(722100, "认证失败:token非法"),
    TOKEN_EXPIRED(722101, "认证失败:token过期,请重新登录"),
    MOBILE_OR_PASSWORD_ERROR(722102, "手机号或密码错误"),
    MOBILE_FORBIDDEN(722103, "手机号被禁用"),
    MOBILE_NON_EXIST(722104, "手机号不存在"),
    VALIDATE_CODE_ERROR(722105, "验证码不正确"),
    NAME_OR_PASSWORD_ERROR(722104, "用户名或密码错误"),

    AUTHORIZATION_FAIL(722110, "您没有权限，请联系管理员"),
    UPLOAD_ERROR(722111, "上传失败"),
    DOWNLOAD_ERROR(722112, "下载失败"),

    UPDATE_FAIL(722200, "更新数据失败"),
    INSERT_FAIL(722201, "添加数据失败"),
    SET_STATUS_ERROR(722300, "抱歉，设置状态失败"),

    SYSTEM_ERROR(722500, "系统异常，操作失败:"),
    NO_DATA(722800, "查无数据"),
    PARAM_VALID_ERROR(722900, "参数校验错误："),
    ;


    private Integer code;
    private String msg;

    RespEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
