package cn.airfei.aircore.core.config;

import lombok.extern.slf4j.Slf4j;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @description:
 * @author: air
 * @create: 2021-01-28 09:53
 */
@Configuration
@Slf4j
public class RedissonConfig {
    @Value("${spring.redis.host}")
    private String address;

    @Value("${spring.redis.password}")
    private String password;

    @Value("${spring.redis.database}")
    private Integer database;

    @Value("${spring.redis.port}")
    private Integer port;

    @Bean
    public RedissonClient getRedisson() {
        Config config = new Config();
        //单机模式  依次设置redis地址和密码
        config.useSingleServer()
                .setAddress("redis://" + address + ":" + (port == null ? 6379 : port))
                .setPassword(password)
                .setDatabase(database == null ? 6 : database)
        ;
        return Redisson.create(config);
    }
}
