package cn.airfei.aircore.core.config;

import cn.airfei.aircore.core.common.Error;
import cn.airfei.aircore.core.utils.SpringContextUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;


/**
 * @description:
 * @author: air
 * @create: 2020-11-12 10:52
 */
@Configuration
public class AirCoreConfig {

    /**
     * 统一异常抛出
     *
     * @return
     */
    @Bean(name = "airCoreError")
    public Error error() {
        return new Error();
    }


    /**
     * 设置请求头
     *
     * @return
     */
    @Bean
    public HttpHeaders httpHeaders() {
        return new HttpHeaders();
    }


    @Bean
    public SpringContextUtil springContextUtil() {
        return new SpringContextUtil();
    }


    /**
     * 跨域问题
     *
     * @return
     */
    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", buildConfig()); //
        return new CorsFilter(source);
    }


    /**
     * 跨域配置
     *
     * @return
     */
    private CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*"); // 1允许任何域名使用
        corsConfiguration.addAllowedHeader("*"); // 2允许任何头
        corsConfiguration.addAllowedMethod("*"); // 3允许任何方法（post、get等）
        return corsConfiguration;
    }


}
