package cn.airfei.aircore.core.common;

import cn.airfei.aircore.core.enums.RespEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 接口返回统一格式
 * 凡是code非0都视为失败
 *
 * @param <T>
 * @author air
 * @create: 2019年12月18日19:29:07
 */
@Data
public class Resp<T> implements Serializable {
    private Integer code;
    private String msg;
    private String traceId;
    private String appId;
    private T data;


    private Resp(T data, Integer code, String msg) {
        this.msg = msg;
        this.data = data;
        this.code = code;
    }

    private Resp(Integer code, String msg) {
        this.msg = msg;
        this.data = null;
        this.code = code;
    }

    private Resp(Integer code, String msg, String traceId) {
        this.msg = msg;
        this.data = null;
        this.code = code;
        this.traceId = traceId;
    }

    private Resp(T data) {
        this.data = data;
        this.msg = RespEnum.SUCCESS.getMsg();
        this.code = RespEnum.SUCCESS.getCode();
    }

    private Resp() {
        this.data = null;
        this.msg = RespEnum.SUCCESS.getMsg();
        this.code = RespEnum.SUCCESS.getCode();
    }


    public static <T> Resp<T> response(T data, Integer code, String msg) {
        return new Resp<T>(data, code, msg);
    }

    public static <T> Resp<T> response(Integer code, String msg) {
        return new Resp<T>(code, msg);
    }

    public static <T> Resp<T> response(Integer code, String msg, String traceId) {
        return new Resp<T>(code, msg, traceId);
    }

    public static <T> Resp<T> response(T data) {
        return new Resp<T>(data);
    }

    public static <T> Resp<T> response() {
        return new Resp<T>();
    }

}
