package ${cfg.ServiceImpl};

import ${cfg.Convertor}.${entity}Convertor;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import ${package.ServiceImpl}.${entity}DomainServiceImpl;
import ${package.Entity}.${table.entityName};
import ${cfg.Dto}.${entity}Dto;
import ${cfg.Vo}.${entity}Vo;
import ${cfg.Service}.I${entity}Service;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import cn.airfei.aircore.core.storage.PageParam;
import cn.airfei.aircore.core.enums.RespEnum;
import cn.airfei.aircore.core.exception.AppException;

/**
 * <p>
 * ${table.comment!}
 * </p>
 *
 * @author ${author}
 * @since ${date}
 */
@Service
<#if kotlin>
open class ${entity}ServiceImpl : ${superServiceImplClass}<${table.mapperName}, ${entity}>(), ${table.serviceName} {

}
<#else>
public class ${entity}ServiceImpl implements I${entity}Service {
    @Resource
    private ${entity}Convertor ${entity?uncap_first}Convertor;

    @Resource
    private ${entity}DomainServiceImpl ${entity?uncap_first}DomainService;


    /**
     *
     * @param ${entity?uncap_first}Dto
     * @param pageParam
     * @return
     */
    @Override
    public Page<${entity}Vo> index(${entity}Dto ${entity?uncap_first}Dto,PageParam pageParam) {
        return ${entity?uncap_first}DomainService.index(${entity?uncap_first}Dto,pageParam);
    }


    /**
     * 分页查询单表数据
     *
     * @param map
     * @return
     */
    @Override
    public Page<${entity}> singleTablePage(Map<String, Object> map) {
        return  ${entity?uncap_first}DomainService.singleTablePage(map);
    }


    /**
     * 显示单条数据
     *
     * @param id
     * @return
     */
    @Override
    public ${entity}Vo show(String id){
        ${entity} ${entity?uncap_first} = ${entity?uncap_first}DomainService.show(id);
        return  ${entity?uncap_first}Convertor.entity2Vo(${entity?uncap_first});
    }


    /**
     * 删除（销毁表数据）
     *
     * @param ids
     * @return
     */
    @Override
    public Integer destroy(String ids){
        return ${entity?uncap_first}DomainService.destroy(ids);
    }


    /**
     * 更新表数据
     * @param ${entity?uncap_first}Dto
     * @return
     */
    @Override
    public Integer update(${entity}Dto ${entity?uncap_first}Dto){
        Integer res = ${entity?uncap_first}DomainService.update(${entity?uncap_first}Convertor.dto2Entity(${entity?uncap_first}Dto));
        if (res < 1) {
            throw new AppException(RespEnum.UPDATE_FAIL.getCode(), RespEnum.UPDATE_FAIL.getMsg());
        }
        return res;
    }


    /**
     * 保存表数据
     *
     * @param {entity?uncap_first}Dto
     * @return
     */
    @Override
    public Integer store(${entity}Dto ${entity?uncap_first}Dto){
        return ${entity?uncap_first}DomainService.store(${entity?uncap_first}Convertor.dto2Entity(${entity?uncap_first}Dto));
    }


    /**
     * 设置状态，1:正常,2:禁用/待审核，-1:已删除
     *
     * @param id
     * @param status
     * @return
     */
    @Override
    public boolean setStatus(<#list table.fields as field><#if field.keyFlag>${field.propertyType}</#if></#list> id, Integer status) {
        if(${entity?uncap_first}DomainService.setStatus(id,status)>0){
            return true;
        }
        throw new AppException(RespEnum.SET_STATUS_ERROR.getCode(),RespEnum.SET_STATUS_ERROR.getMsg());
    }


    /**
     * get all resource in storage
     * @return
     */
    @Override
    public List<${entity}Vo> getAll${entity}() {
        return ${entity?uncap_first}Convertor.entityList2VoList(${entity?uncap_first}DomainService.getAll${entity}());
    }

}
</#if>
