/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.utils;

import cn.airfei.aircore.core.exception.AppException;
import cn.airfei.aircore.core.utils.FieldUtil;
import cn.airfei.aircore.core.utils.SQLFilterUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QueryParamUtil {
    private static String qpPrefix = "qp-";
    private static String splitStr = "-";
    private static final String BRACKETS = "[]";
    private static final String KEY_IN = "in,notIn";

    public static QueryWrapper getEntityWrapper(Map<String, Object> params, Class clz) {
        QueryWrapper ew = new QueryWrapper();
        return QueryParamUtil.getEntityWrapper(params, ew, clz);
    }

    public static QueryWrapper getEntityWrapper(Map<String, Object> params, QueryWrapper ew, Class clz) {
        params.forEach((k, v) -> {
            if (k.startsWith(qpPrefix)) {
                Map<String, String> qpMap = QueryParamUtil.getQueryParamMap(k);
                String fieldName = qpMap.get("fieldName");
                String camelFieldName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
                if (v != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{v.toString()})) {
                    QueryParamUtil.freshEw(ew, qpMap.get("option"), qpMap.get("fieldName"), QueryParamUtil.formatFieldVal(camelFieldName, v, clz, qpMap.get("option")));
                }
            }
        });
        return ew;
    }

    private static QueryWrapper freshEw(QueryWrapper ew, String option, String fieldName, Object value) {
        switch (option) {
            case "eq": {
                ew.eq((Object)fieldName, value);
                break;
            }
            case "ne": {
                ew.ne((Object)fieldName, value);
                break;
            }
            case "gt": {
                ew.gt((Object)fieldName, value);
                break;
            }
            case "ge": {
                ew.ge((Object)fieldName, value);
                break;
            }
            case "le": {
                ew.le((Object)fieldName, value);
                break;
            }
            case "lt": {
                ew.lt((Object)fieldName, value);
                break;
            }
            case "in": {
                if (value instanceof ArrayList) {
                    ew.in((Object)fieldName, (Collection)((ArrayList)value));
                    break;
                }
                ew.in((Object)fieldName, new Object[]{value});
                break;
            }
            case "notIn": {
                if (value instanceof ArrayList) {
                    ew.notIn((Object)fieldName, (Collection)((ArrayList)value));
                    break;
                }
                ew.notIn((Object)fieldName, new Object[]{value});
                break;
            }
            case "like": {
                ew.like((Object)fieldName, value);
                break;
            }
            case "notLike": {
                ew.notLike((Object)fieldName, value);
                break;
            }
            case "likeleft": {
                ew.likeLeft((Object)fieldName, value);
                break;
            }
            case "likeright": {
                ew.likeRight((Object)fieldName, value);
                break;
            }
        }
        return ew;
    }

    private static Map<String, String> getQueryParamMap(String paramStr) {
        int len;
        HashMap retMap = Maps.newHashMap();
        paramStr = SQLFilterUtil.sqlInject(paramStr);
        String[] params = StringUtils.split((String)(paramStr = StringUtils.removeStart((String)paramStr, (String)qpPrefix)), (String)splitStr);
        if (params.length == (len = 2)) {
            retMap.put("fieldName", FieldUtil.toDBField(params[0]));
            retMap.put("option", params[1]);
        }
        return retMap;
    }

    public static Field getDeclaredField(Class clazz, String fieldName) {
        if (ObjectUtils.isNull((Object[])new Object[]{clazz, fieldName})) {
            return null;
        }
        Field field = null;
        while (clazz != Object.class) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        return field;
    }

    private static Object formatFieldVal(String key, Object val, Class tClass, String option) {
        Field field = QueryParamUtil.getDeclaredField(tClass, key);
        if (field == null) {
            StringBuilder sb = new StringBuilder("==Can't find the type corresponding to the query parameter! key=").append(key).append(",val=").append(val).append("tClass=").append(tClass);
            throw new AppException(sb.toString());
        }
        Class<?> clz = field.getType();
        String baseType = clz.getTypeName();
        return QueryParamUtil.castType(baseType, val, option);
    }

    public static Object castType(String fieldNameType, Object val, String option) {
        ArrayList<Double> ret;
        if (val == null || StringUtils.isBlank((CharSequence)((Object)val).toString())) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String valStr = String.valueOf(val);
        String simpleTypeName = StringUtils.substringAfterLast((String)("." + fieldNameType), (String)".").toLowerCase();
        if (StringUtils.isNotBlank((CharSequence)option) && KEY_IN.contains(option) && !simpleTypeName.endsWith(BRACKETS)) {
            simpleTypeName = simpleTypeName + BRACKETS;
        }
        switch (simpleTypeName) {
            case "double": {
                ret = Double.parseDouble(valStr);
                break;
            }
            case "float": {
                ret = Float.valueOf(Float.parseFloat(valStr));
                break;
            }
            case "short": {
                ret = Short.parseShort(valStr);
                break;
            }
            case "integer": {
                ret = Integer.parseInt(valStr);
                break;
            }
            case "int": {
                ret = Integer.parseInt(valStr);
                break;
            }
            case "long": {
                ret = Long.parseLong(valStr);
                break;
            }
            case "boolean": {
                ret = Boolean.parseBoolean(valStr);
                break;
            }
            case "double[]": {
                String[] str = valStr.split(",");
                ArrayList<Double> listDouble = new ArrayList<Double>();
                for (int i = 0; i < str.length; ++i) {
                    listDouble.add(Double.parseDouble(str[i]));
                }
                ret = listDouble;
                break;
            }
            case "float[]": {
                String[] str = valStr.split(",");
                ArrayList<Float> listFloat = new ArrayList<Float>();
                for (int i = 0; i < str.length; ++i) {
                    listFloat.add(Float.valueOf(Float.parseFloat(str[i])));
                }
                ret = listFloat;
                break;
            }
            case "short[]": {
                String[] str = valStr.split(",");
                ArrayList<Short> shortList = new ArrayList<Short>();
                for (int i = 0; i < str.length; ++i) {
                    shortList.add(Short.parseShort(str[i]));
                }
                ret = shortList;
                break;
            }
            case "integer[]": {
                String[] str = valStr.split(",");
                ArrayList<Integer> listInteger = new ArrayList<Integer>();
                for (int i = 0; i < str.length; ++i) {
                    listInteger.add(Integer.parseInt(str[i]));
                }
                ret = listInteger;
                break;
            }
            case "int[]": {
                String[] str = valStr.split(",");
                ArrayList<Integer> listInt = new ArrayList<Integer>();
                for (int i = 0; i < str.length; ++i) {
                    listInt.add(Integer.parseInt(str[i]));
                }
                ret = listInt;
                break;
            }
            case "long[]": {
                String[] str = valStr.split(",");
                ArrayList<Long> listLong = new ArrayList<Long>();
                for (int i = 0; i < str.length; ++i) {
                    listLong.add(Long.parseLong(str[i]));
                }
                ret = listLong;
                break;
            }
            case "string[]": {
                String[] str = valStr.split(",");
                ArrayList<String> listString = new ArrayList<String>();
                for (int i = 0; i < str.length; ++i) {
                    listString.add(str[i]);
                }
                ret = listString;
                break;
            }
            case "bigdecimal": {
                ret = new BigDecimal(valStr);
                break;
            }
            case "biginteger": {
                ret = new BigInteger(valStr);
                break;
            }
            case "localdate": {
                ret = LocalDate.parse(valStr);
                break;
            }
            case "localtime": {
                ret = LocalTime.parse(valStr);
                break;
            }
            case "localdatetime": {
                ret = LocalDateTime.parse(valStr, df);
                break;
            }
            default: {
                ret = val;
            }
        }
        return ret;
    }
}

