/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.utils;

import cn.airfei.aircore.core.storage.Pojo.FileUtilPojo;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    private String relativePath = "";
    private String absolutePath = "";
    private String oldName = "";
    private String newName = "";

    public boolean upload(MultipartFile file, String path) {
        LocalDate toDay = LocalDate.now();
        String fileName = file.getOriginalFilename();
        String suffixName = fileName.substring(fileName.lastIndexOf("."));
        String newFileName = UUID.randomUUID().toString().replace("-", "");
        String relativePath = toDay + "/" + newFileName + suffixName;
        String realPath = path + relativePath;
        File dest = new File(realPath);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdir();
        }
        try {
            file.transferTo(dest);
            this.setOldName(fileName);
            this.setNewName(newFileName + suffixName);
            this.setRelativePath(relativePath);
            this.setAbsolutePath(realPath);
            return true;
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<FileUtilPojo> readAllFiles(String path) {
        ArrayList<FileUtilPojo> fileUtilPojoList = new ArrayList<FileUtilPojo>();
        File file = new File(path);
        FileUtil.recursionReadFiles(file, fileUtilPojoList);
        return fileUtilPojoList;
    }

    private static void recursionReadFiles(File file, List<FileUtilPojo> fileUtilPojoList) {
        File[] fs;
        for (File f : fs = file.listFiles()) {
            if (f.isDirectory()) {
                FileUtil.recursionReadFiles(f, fileUtilPojoList);
            }
            if (!f.isFile()) continue;
            FileUtilPojo fileUtilPojo = new FileUtilPojo();
            fileUtilPojo.setFilePath(f.getAbsolutePath());
            fileUtilPojo.setModifiedTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(f.lastModified()), ZoneId.systemDefault()));
            fileUtilPojoList.add(fileUtilPojo);
        }
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileUtil)) {
            return false;
        }
        FileUtil other = (FileUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$relativePath = this.getRelativePath();
        String other$relativePath = other.getRelativePath();
        if (this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath)) {
            return false;
        }
        String this$absolutePath = this.getAbsolutePath();
        String other$absolutePath = other.getAbsolutePath();
        if (this$absolutePath == null ? other$absolutePath != null : !this$absolutePath.equals(other$absolutePath)) {
            return false;
        }
        String this$oldName = this.getOldName();
        String other$oldName = other.getOldName();
        if (this$oldName == null ? other$oldName != null : !this$oldName.equals(other$oldName)) {
            return false;
        }
        String this$newName = this.getNewName();
        String other$newName = other.getNewName();
        return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
        String $absolutePath = this.getAbsolutePath();
        result = result * 59 + ($absolutePath == null ? 43 : $absolutePath.hashCode());
        String $oldName = this.getOldName();
        result = result * 59 + ($oldName == null ? 43 : $oldName.hashCode());
        String $newName = this.getNewName();
        result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
        return result;
    }

    public String toString() {
        return "FileUtil(relativePath=" + this.getRelativePath() + ", absolutePath=" + this.getAbsolutePath() + ", oldName=" + this.getOldName() + ", newName=" + this.getNewName() + ")";
    }
}

