/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.generator;

import cn.airfei.aircore.core.generator.CustomCodeGeneratorConfig;
import cn.airfei.aircore.core.properties.CodeGeneratorProperty;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class CodeGenerator {
    public void generator(DataSourceProperties dataSourceProperties, CodeGeneratorProperty codeGeneratorProperty) {
        codeGeneratorProperty.setModulePath(codeGeneratorProperty.getProjectPath() + "/src/main/java/" + codeGeneratorProperty.getParent().replace(".", "/") + "/" + codeGeneratorProperty.getModuleName());
        CustomCodeGeneratorConfig customCodeGeneratorConfig = new CustomCodeGeneratorConfig();
        AutoGenerator mpg = new AutoGenerator();
        TableInfo tableInfo = new TableInfo();
        GlobalConfig gc = new GlobalConfig();
        String projectPath = System.getProperty("user.dir");
        gc.setOutputDir(projectPath + "/src/main/java");
        if (StringUtils.isNotEmpty((CharSequence)codeGeneratorProperty.getAuthor())) {
            gc.setAuthor(codeGeneratorProperty.getAuthor());
        } else {
            gc.setAuthor("air");
        }
        gc.setOpen(false);
        gc.setSwagger2(true);
        gc.setServiceName("I%sDomainService");
        gc.setServiceImplName("%sDomainServiceImpl");
        mpg.setGlobalConfig(gc);
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl(dataSourceProperties.getUrl());
        dsc.setDriverName(dataSourceProperties.getDriverClassName());
        dsc.setUsername(dataSourceProperties.getUsername());
        dsc.setPassword(dataSourceProperties.getPassword());
        mpg.setDataSource(dsc);
        final PackageConfig pc = new PackageConfig();
        pc.setModuleName(codeGeneratorProperty.getModuleName());
        pc.setParent(codeGeneratorProperty.getParent());
        pc.setEntity("storage.entity");
        pc.setServiceImpl("domain.service.impl");
        pc.setService("domain.service");
        pc.setController("rest.controller");
        mpg.setPackageInfo(pc);
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Api", pc.getParent() + ".rest.api");
                map.put("Po", pc.getParent() + ".storage.po");
                map.put("Vo", pc.getParent() + ".storage.vo");
                map.put("Dto", pc.getParent() + ".storage.dto");
                map.put("Entity", pc.getParent() + ".storage.entity");
                map.put("Service", pc.getParent() + ".service");
                map.put("ServiceImpl", pc.getParent() + ".service.impl");
                map.put("Convertor", pc.getParent() + ".domain.convertor");
                map.put("Config", pc.getParent() + ".config");
                map.put("Parent", pc.getParent());
                map.put("Handler", pc.getParent() + ".handler");
                this.setMap(map);
            }
        };
        ArrayList<FileOutConfig> focList = new ArrayList<FileOutConfig>();
        customCodeGeneratorConfig.mapper(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.mapperXml(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.controller(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.api(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.domainserviceImpl(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.domainservice(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.serviceImpl(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.service(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.entity(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.vo(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.dto(codeGeneratorProperty, focList);
        customCodeGeneratorConfig.convertor(codeGeneratorProperty, focList);
        cfg.setFileOutConfigList(focList);
        mpg.setCfg(cfg);
        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setXml(null);
        mpg.setTemplate(templateConfig);
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setRestControllerStyle(true);
        if (StringUtils.isNotEmpty((CharSequence)codeGeneratorProperty.getIncludeTables())) {
            strategy.setInclude(codeGeneratorProperty.getIncludeTables().split(","));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeGeneratorProperty.getExcludeTables())) {
            strategy.setExclude(new String[]{codeGeneratorProperty.getExcludeTables()});
        }
        strategy.setControllerMappingHyphenStyle(true);
        if (StringUtils.isNotEmpty((CharSequence)codeGeneratorProperty.getTablePrefix())) {
            strategy.setTablePrefix(new String[]{codeGeneratorProperty.getTablePrefix()});
        }
        mpg.setStrategy(strategy);
        mpg.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        mpg.execute();
    }
}

