/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.common;

import cn.airfei.aircore.core.common.Resp;
import cn.airfei.aircore.core.enums.RespEnum;
import cn.airfei.aircore.core.exception.AppException;
import cn.airfei.aircore.core.extend.InsertLogToMongoDb;
import cn.airfei.aircore.core.extend.ParseHeaderAuthorization;
import cn.airfei.aircore.core.properties.AirCoreProperty;
import cn.airfei.aircore.core.storage.Pojo.LogForMongoDbPojo;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import springfox.documentation.annotations.ApiIgnore;

@RestControllerAdvice
@Component
@ApiIgnore
public class Error
implements ErrorController {
    private static final Logger log = LoggerFactory.getLogger(Error.class);
    @Resource
    private AirCoreProperty airCoreProperty;
    @Resource
    private InsertLogToMongoDb insertLogToMongoDb;
    @Resource
    private ParseHeaderAuthorization parseHeaderAuthorization;

    public String getErrorPath() {
        return null;
    }

    @ExceptionHandler(value={Exception.class})
    public Resp defaultErrorHandler(HttpServletRequest req, Exception e, HttpServletResponse response) throws Exception {
        if (this.airCoreProperty.getSetLogToMongoDb().booleanValue()) {
            String url = String.valueOf(req.getRequestURL());
            if (!StringUtils.isEmpty((CharSequence)req.getQueryString())) {
                url = url + "?" + req.getQueryString();
            }
            LogForMongoDbPojo logForMongoDbPojo = new LogForMongoDbPojo();
            logForMongoDbPojo.setErrMsg(e.getMessage());
            logForMongoDbPojo.setCreateTime(LocalDateTime.now());
            logForMongoDbPojo.setUrl(url);
            logForMongoDbPojo.setTraceId(String.valueOf(req.getAttribute("traceId")));
            logForMongoDbPojo.setIp(req.getRemoteAddr());
            logForMongoDbPojo.setMethod(req.getMethod());
            logForMongoDbPojo.setErrCode(RespEnum.SYSTEM_ERROR.getCode());
            this.parseHeaderAuthorization.setLoginInfo(logForMongoDbPojo);
            this.insertLogToMongoDb.insertLog(logForMongoDbPojo);
        }
        log.error("path:{},errorMsg:{}", (Object)(req.getContextPath() + req.getServletPath() + "?" + req.getQueryString()), (Object)e.getMessage());
        return Resp.response(RespEnum.SYSTEM_ERROR.getCode(), RespEnum.SYSTEM_ERROR.getMsg() + e.getMessage(), String.valueOf(req.getAttribute("traceId")));
    }

    @ExceptionHandler(value={AppException.class})
    public Resp appExceptionHandler(HttpServletRequest req, AppException e) {
        if (this.airCoreProperty.getSetLogToMongoDb().booleanValue()) {
            String url = String.valueOf(req.getRequestURL());
            if (!StringUtils.isEmpty((CharSequence)req.getQueryString())) {
                url = url + "?" + req.getQueryString();
            }
            LogForMongoDbPojo logForMongoDbPojo = new LogForMongoDbPojo();
            logForMongoDbPojo.setErrMsg(e.getMsg());
            logForMongoDbPojo.setCreateTime(LocalDateTime.now());
            logForMongoDbPojo.setUrl(url);
            logForMongoDbPojo.setTraceId(String.valueOf(req.getAttribute("traceId")));
            logForMongoDbPojo.setIp(req.getRemoteAddr());
            logForMongoDbPojo.setMethod(req.getMethod());
            logForMongoDbPojo.setErrCode(e.getCode());
            this.parseHeaderAuthorization.setLoginInfo(logForMongoDbPojo);
            this.insertLogToMongoDb.insertLog(logForMongoDbPojo);
        }
        log.error("path:{},errorMsg:{}", (Object)(req.getContextPath() + req.getServletPath() + "?" + req.getQueryString()), (Object)e.getMessage());
        return Resp.response(e.getCode(), e.getMsg(), String.valueOf(req.getAttribute("traceId")));
    }
}

