package cn.airfei.aircore.core.utils;

import cn.airfei.aircore.core.exception.AppException;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: air
 * @create: 2019-12-28 16:25
 **/
public class QueryParamUtil {
    /**
     * 查询条件参数前缀，只将前台传回的带此前缀的param才加入过滤条件中
     **/
    private static String qpPrefix = "qp-";
    private static String splitStr = "-";
    private final static String BRACKETS = "[]";
    private final static String KEY_IN = "in,notIn";

    public static QueryWrapper getEntityWrapper(Map<String, Object> params, Class clz) {
        QueryWrapper ew = new QueryWrapper();
        return getEntityWrapper(params, ew, clz);
    }

    public static QueryWrapper getEntityWrapper(Map<String, Object> params, QueryWrapper ew, Class clz) {
        params.forEach((k, v) -> {
            if (k.startsWith(qpPrefix)) {
                Map<String, String> qpMap = getQueryParamMap(k);
                /**
                 * fieldName: AAA_BBB_CCC
                 * camelFieldName: aaaBbbCcc
                 */
                String fieldName = qpMap.get("fieldName");
                String camelFieldName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
                if (v != null && StringUtils.isNoneBlank(v.toString())) {
                    freshEw(ew, qpMap.get("option"), qpMap.get("fieldName"), formatFieldVal(camelFieldName, v, clz, qpMap.get("option")));
                }
            }
        });

        return ew;
    }

    private static QueryWrapper freshEw(QueryWrapper ew, String option, String fieldName, Object value) {
        switch (option) {
            case "eq":
                ew.eq(fieldName, value);
                break;//等于=
            case "ne":
                ew.ne(fieldName, value);
                break;//不等于<>
            case "gt":
                ew.gt(fieldName, value);
                break;//大于>
            case "ge":
                ew.ge(fieldName, value);
                break;//大于等于>=
            case "le":
                ew.le(fieldName, value);
                break;//小于等于<=
            case "lt":
                ew.lt(fieldName, value);
                break;//小于<
            case "in":
                if (value instanceof ArrayList) {
                    ew.in(fieldName, (ArrayList) value);
                } else {
                    ew.in(fieldName, value);
                }
                break;
            case "notIn":
                if (value instanceof ArrayList) {
                    ew.notIn(fieldName, (ArrayList) value);
                } else {
                    ew.notIn(fieldName, value);
                }
                break;
            case "like":
                ew.like(fieldName, value);
                break;//模糊查询 LIKE
            case "notLike":
                ew.notLike(fieldName, value);
                break;//模糊查询 NOT LIKE
            case "likeleft":
                ew.likeLeft(fieldName, value);
                break;//模糊查询 左边LIKE '%xxx'
            case "likeright":
                ew.likeRight(fieldName, value);
                break;//模糊查询 右边LIKE 'xx%'
            default:
                break;
        }
        return ew;
    }

    private static Map<String, String> getQueryParamMap(String paramStr) {
        Map retMap = Maps.newHashMap();
        paramStr = SQLFilterUtil.sqlInject(paramStr);
        paramStr = StringUtils.removeStart(paramStr, qpPrefix);
        String[] params = StringUtils.split(paramStr, splitStr);
        int len = 2;
        if (params.length == len) {
            retMap.put("fieldName", FieldUtil.toDBField(params[0]));
            retMap.put("option", params[1]);
        }
        return retMap;
    }

    /**
     * 当前类取不到属性，循环向上（父类）取
     */
    public static Field getDeclaredField(Class clazz, String fieldName) {
        if (ObjectUtils.isNull(clazz, fieldName)) {
            return null;
        }
        Field field = null;
        for (; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            } catch (Exception e) {
            }
        }
        return field;
    }

    /**
     * 查询参数的值val根据Class附加上具体的类型信息。
     */
    private static Object formatFieldVal(String key, Object val, Class tClass, String option) {
        Field field = getDeclaredField(tClass, key);
        if (field == null) {
            StringBuilder sb =
                    new StringBuilder("==Can't find the type corresponding to the query parameter! key=").append(key)
                            .append(",val=").append(val).append("tClass=").append(tClass);
            throw new AppException(sb.toString());
        }
        Class clz = field.getType();
        String baseType = clz.getTypeName();
        return castType(baseType, val, option);
    }

    /**
     * 查询字段类型的转换 查询字段默认转进来的值都是字符串，需要根据PO类型作转换
     */
    public static Object castType(String fieldNameType, Object val, String option) {
        if (val == null || StringUtils.isBlank(val.toString())) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Object ret;
        String[] str;
        String valStr = String.valueOf(val);
        String simpleTypeName = StringUtils.substringAfterLast("." + fieldNameType, ".").toLowerCase();
        //判断是否是数组
        if (StringUtils.isNotBlank(option) && KEY_IN.contains(option) && !simpleTypeName.endsWith(BRACKETS)) {
            simpleTypeName = simpleTypeName + BRACKETS;
        }
        switch (simpleTypeName) {
            /**需要转换的基本类型**/
            case "double":
                ret = Double.parseDouble(valStr);
                break;
            case "float":
                ret = Float.parseFloat(valStr);
                break;
            case "short":
                ret = Short.parseShort(valStr);
                break;
            case "integer":
                ret = Integer.parseInt(valStr);
                break;
            case "int":
                ret = Integer.parseInt(valStr);
                break;
            case "long":
                ret = Long.parseLong(valStr);
                break;
            case "boolean":
                ret = Boolean.parseBoolean(valStr);
                break;
            /**基本类型的数组**/
            case "double[]":
                str = valStr.split(",");
                List<Double> listDouble = new ArrayList<>();
                for (int i = 0; i < str.length; i++) {
                    listDouble.add(Double.parseDouble(str[i]));
                }
                ret = listDouble;
                break;
            case "float[]":
                str = valStr.split(",");
                List<Float> listFloat = new ArrayList<>();
                for (int i = 0; i < str.length; i++) {
                    listFloat.add(Float.parseFloat(str[i]));
                }
                ret = listFloat;
                break;
            case "short[]":
                str = valStr.split(",");
                List<Short> shortList = new ArrayList<>();
                for (int i = 0; i < str.length; i++) {
                    shortList.add(Short.parseShort(str[i]));
                }
                ret = shortList;
                break;
            case "integer[]":
                str = valStr.split(",");
                List<Integer> listInteger = new ArrayList<>();
                for (int i = 0; i < str.length; i++) {
                    listInteger.add(Integer.parseInt(str[i]));
                }
                ret = listInteger;
                break;
            case "int[]":
                str = valStr.split(",");
                List<Integer> listInt = new ArrayList<>();
                for (int i = 0; i < str.length; i++) {
                    listInt.add(Integer.parseInt(str[i]));
                }
                ret = listInt;
                break;
            case "long[]":
                str = valStr.split(",");
                List<Long> listLong = new ArrayList<>();
                for (int i = 0; i < str.length; i++) {
                    listLong.add(Long.parseLong(str[i]));
                }
                ret = listLong;
                break;
            case "string[]":
                str = valStr.split(",");
                List<String> listString = new ArrayList<>();
                for (int i = 0; i < str.length; i++) {
                    listString.add(str[i]);
                }
                ret = listString;
                break;
            /** 枚举 暂没实现（生成的po代码，暂时没有枚举型的） **/
            case "bigdecimal":
                ret = new BigDecimal(valStr);
                break;
            case "biginteger":
                ret = new BigInteger(valStr);
                break;
            /**日期时间**/
            case "localdate":
                ret = LocalDate.parse(valStr);
                break;
            case "localtime":
                ret = LocalTime.parse(valStr);
                break;
            case "localdatetime":
                ret = LocalDateTime.parse(valStr, df);
                break;
            default:
                ret = val;
                break;
        }
        return ret;
    }

}
