package cn.airfei.aircore.core.properties;

import lombok.Data;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: air
 * @create: 2019-12-30 17:37
 **/
@Component
@ConfigurationProperties(prefix = "air.core.generator")
@Data
public class CodeGeneratorProperty {
    private String author;

    private String outputDir;

    private String parent;

    private String entity;

    private String service;

    private String serviceImpl;

    private String ServiceName;

    private String serviceImplName;

    // 模块名称
    private String moduleName = "";

    // 模块路径
    private String modulePath;

    private String tablePrefix;

    private String includeTables;

    private String excludeTables;

    private String projectPath = System.getProperty("user.dir");

}
