package cn.airfei.aircore.core.interceptor;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @description: 拦截所有请求(预处理), 并设置较高优先级(比默认优先级高)
 * @author: air
 * @create: 2020-11-07 11:21
 */
@Slf4j
public class AllInterceptor implements HandlerInterceptor {
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceId;
        if (StringUtils.isEmpty(request.getHeader("traceId"))){
            traceId = IdWorker.getTimeId();
        }else {
            traceId= String.valueOf(request.getHeader("traceId"));
        }
        log.info("[traceId]:{}", traceId);
        request.setAttribute("traceId",traceId);
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {

    }
}
