package cn.airfei.aircore.core.generator;

import cn.airfei.aircore.core.properties.CodeGeneratorProperty;
import com.baomidou.mybatisplus.core.toolkit.StringPool;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;


import java.util.List;

/**
 * @description: 自定义配置文件
 * @author: air
 * @create: 2019-12-30 17:34
 **/
public class CustomCodeGeneratorConfig {
    private  String templatePath;


    public void mapperXml(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        // 如果模板引擎是 freemarker
        String templatePath = "/templates/air/mapper.xml.ftl";
        // 如果模板引擎是 velocity
        // String templatePath = "/templates/mapper.xml.vm";
        // 自定义配置会被优先输出
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                // 自定义输出文件名 ， 如果你 Entity 设置了前后缀、此处注意 xml 的名称会跟着发生变化！！
                return codeGeneratorProperty.getProjectPath() + "/src/main/resources/mapper/" + codeGeneratorProperty.getModuleName()
                        + "/" + tableInfo.getEntityName() + "Mapper" + StringPool.DOT_XML;
            }
        });
    }


    public  void mapper(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        String templatePath="/templates/air/mapper.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+ "/mapper/" + tableInfo.getEntityName()+"Mapper" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }


    public  void   mybatisPlusConfig(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        String templatePath="/templates/air/mybatisPlusConfig.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+ "/config/" + "MybatisPlusConfig" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public  void aircoreConfig(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/airCoreConfig.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+ "/config/" + "AirCoreConfig" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public  void corsConfig(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/corsConfig.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+ "/config/" + "CORSConfig" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    /**
     * mybatis plus 自动生成数据（时间等）
     * @param codeGeneratorProperty
     * @param focList
     */
    public  void myMetaObjectHandler(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/myMetaObjectHandler.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+ "/handler/" + "MyMetaObjectHandler" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public  void swaggerConfig(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/swaggerConfig.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+ "/config/" + "SwaggerConfig" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public void convertor(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/convertor.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()
                        + "/domain/convertor/" + tableInfo.getEntityName() + "Convertor" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public void dto(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/dto.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+"/storage/dto/" + tableInfo.getEntityName() + "Dto" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }


    public void vo(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/vo.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+"/storage/vo/" + tableInfo.getEntityName() + "Vo" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }


    public void entity(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/entity.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()+"/storage/entity/"+ tableInfo.getEntityName() + StringPool.DOT_JAVA;
                return path;
            }
        });
    }


    public void service(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath= "/templates/air/service.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()
                        + "/service/I" + tableInfo.getEntityName() + "Service" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public void serviceImpl(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath= "/templates/air/serviceImpl.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                // 自定义输出文件名 ， 如果你 Entity 设置了前后缀、此处注意 xml 的名称会跟着发生变化！！
                String path=codeGeneratorProperty.getModulePath()
                        + "/service/impl/" + tableInfo.getEntityName() + "ServiceImpl" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public void domainservice(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath= "/templates/air/domainservice.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()
                        + "/domain/service/I" + tableInfo.getEntityName() + "DomainService" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }


    public void domainserviceImpl(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath= "/templates/air/domainserviceImpl.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                String path=codeGeneratorProperty.getModulePath()
                        + "/domain/service/impl/" + tableInfo.getEntityName() + "DomainServiceImpl" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public void api(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/api.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                // 自定义输出文件名 ， 如果你 Entity 设置了前后缀、此处注意 xml 的名称会跟着发生变化！！
                String path=codeGeneratorProperty.getModulePath()
                        + "/rest/api/" + tableInfo.getEntityName() + "Api" + StringPool.DOT_JAVA;
                return path;
            }
        });
    }

    public void controller(CodeGeneratorProperty codeGeneratorProperty,List<FileOutConfig> focList){
        templatePath="/templates/air/controller.java.ftl";
        focList.add(new FileOutConfig(templatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                // 自定义输出文件名 ， 如果你 Entity 设置了前后缀、此处注意 xml 的名称会跟着发生变化！！
                String path=codeGeneratorProperty.getModulePath()
                        + "/rest/controller/" + tableInfo.getEntityName() + "Controller" + StringPool.DOT_JAVA;
                System.out.println("生成"+tableInfo.getEntityName()+"controller成功，路径："+path);
                return path;
            }
        });
    }



}
