package cn.airfei.aircore.core.extend;

import cn.airfei.aircore.core.properties.AirCoreProperty;
import cn.airfei.aircore.core.storage.bo.TokenBo;
import cn.airfei.aircore.core.utils.EncryptionUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @description: 解析头部的 Authorization
 * @author: air
 * @create: 2020-11-13 09:14
 */
@Component
public class ParseHeaderAuthorization {
    @Resource
    private AirCoreProperty airCoreProperty;

    /**
     * 解析请求头中的 Authorization
     *
     * @return
     */
    public TokenBo parse() {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String token = request.getHeader("Authorization");
        if (StringUtils.isEmpty(token)) {
            return null;
        }
        token = token.replace("Bearer ", "");
        try {
            String desToken = EncryptionUtil.desEncrypt(token, airCoreProperty.getEncryptKey(), airCoreProperty.getEncryptIv());
            return JSONObject.parseObject(desToken, TokenBo.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取登录的用户id
     *
     * @return
     */
    public Long getLoginUserId() {
        TokenBo tokenBo = parse();
        if (tokenBo != null) {
            return tokenBo.getUserId();
        }
        return null;
    }


    /**
     * 获取登录用户名
     *
     * @return
     */
    public String getLoginUserName() {
        TokenBo tokenBo = parse();
        if (tokenBo != null) {
            return tokenBo.getUsername();
        }
        return null;
    }


    /**
     * 获取登录用户手机号
     *
     * @return
     */
    public Long getLoginMobile() {
        TokenBo tokenBo = parse();
        if (tokenBo != null) {
            return tokenBo.getMobile();
        }
        return null;
    }
}
