package cn.airfei.aircore.core.extend;

import cn.airfei.aircore.core.properties.AirCoreProperty;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @description:
 * @author: air
 * @create: 2020-11-06 11:14
 */
@Component
@EnableAsync
public class InsertLogToMongoDb {
    @Resource
    private MongoTemplate mongoTemplate;

    @Resource
    private AirCoreProperty airCoreProperty;

    @Async
    public void insertLog(Object obj) {
        if (airCoreProperty.getSetLogToMongoDb()) {
            mongoTemplate.insert(obj, airCoreProperty.getWebLogTableNameForMongoDb());
        }
    }

}
