package cn.airfei.aircore.core.config;

import cn.airfei.aircore.core.aspect.AllControllerLogAspect;
import cn.airfei.aircore.core.common.Error;
import cn.airfei.aircore.core.extend.AssembleLogForMongoDbPojo;
import cn.airfei.aircore.core.extend.InsertLogToMongoDb;
import cn.airfei.aircore.core.extend.ParseHeaderAuthorization;
import cn.airfei.aircore.core.interceptor.RestTemplateInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: air
 * @create: 2020-11-12 10:52
 */
@Configuration
public class AirCoreConfig {
    @Resource
    private RestTemplateInterceptor restTemplateInterceptor;

    /**
     * 统一异常抛出
     *
     * @return
     */
    @Bean(name = "airCoreError")
    public Error error() {
        return new Error();
    }




    /**
     * 设置请求头
     *
     * @return
     */
    @Bean
    public HttpHeaders httpHeaders() {
        return new HttpHeaders();
    }

    /**
     * 日志aop
     *
     * @return
     */
    @Bean
    public AllControllerLogAspect allControllerLogAspect() {
        return new AllControllerLogAspect();
    }

    /**
     * 配置写日志到mongoDb(controller层)
     * 会记录请求参数和返回结果等
     *
     * @return
     */
    @Bean
    public InsertLogToMongoDb insertLogToMongoDb() {
        return new InsertLogToMongoDb();
    }


    /**
     * restTemplate 拦截器,主要写日志
     * @return
     */
    @Bean
    public RestTemplateInterceptor restTemplateInterceptor() {
        return new RestTemplateInterceptor();
    }


    /**
     * restTemplate
     *
     * @return
     */
    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate(new BufferingClientHttpRequestFactory(new SimpleClientHttpRequestFactory()));
        List<ClientHttpRequestInterceptor> interceptors = new ArrayList<>();
        interceptors.add(restTemplateInterceptor);
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }


    /**
     * 跨域问题
     *
     * @return
     */
    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", buildConfig()); //
        return new CorsFilter(source);
    }


    /**
     * 跨域配置
     *
     * @return
     */
    private CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*"); // 1允许任何域名使用
        corsConfiguration.addAllowedHeader("*"); // 2允许任何头
        corsConfiguration.addAllowedMethod("*"); // 3允许任何方法（post、get等）
        return corsConfiguration;
    }




    @Bean
    public ParseHeaderAuthorization parseHeaderAuthorization(){
        return new ParseHeaderAuthorization();
    }

    @Bean
    public AssembleLogForMongoDbPojo assembleLogForMongoDbPojo(){
        return new AssembleLogForMongoDbPojo();
    }

}
