/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.kit;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

/**
 * 反射工具类
 */
public class ReflectKit {

	public static Object newInstance(Class<?> clazz) {
		try {
			return clazz.newInstance();
		} catch (ReflectiveOperationException e) {
			throw new RuntimeException(e);
		}
	}

	public static String getMethodSignature(Method method) {
		StringBuilder ret = new StringBuilder()
				.append(method.getDeclaringClass().getName())
				.append(".")
				.append(method.getName())
				.append("(");

		int index = 0;
		Parameter[] paras = method.getParameters();
		for (Parameter p : paras) {
			if (index++ > 0) {
				ret.append(", ");
			}
			ret.append(p.getParameterizedType().getTypeName());
		}

		return ret.append(")").toString();
	}

	/*
	public static String getMethodSignature(Method method) {
		StringBuilder ret = new StringBuilder()
				.append(method.getDeclaringClass().getName())
				.append(".")
				.append(method.getName())
				.append("(");

		int index = 0;
		java.lang.reflect.Type[] paraTypes = method.getGenericParameterTypes();
		for (java.lang.reflect.Type type : paraTypes) {
			if (index++ > 0) {
				ret.append(", ");
			}
			ret.append(type.getTypeName());
		}

		return ret.append(")").toString();
	}*/

}






