/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.kit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * JavaKeyword.
 */
public class JavaKeyword {

	private String[] keywordArray = {
		"abstract",
		"assert",
		"boolean",
		"break",
		"byte",
		"case",
		"catch",
		"char",
		"class",
		"const",
		"continue",
		"default",
		"do",
		"double",
		"else",
		"enum",
		"extends",
		"final",
		"finally",
		"float",
		"for",
		"goto",
		"if",
		"implements",
		"import",
		"instanceof",
		"int",
		"interface",
		"long",
		"native",
		"new",
		"package",
		"private",
		"protected",
		"public",
		"return",
		"strictfp",
		"short",
		"static",
		"super",
		"switch",
		"synchronized",
		"this",
		"throw",
		"throws",
		"transient",
		"try",
		"void",
		"volatile",
		"while"
	};

	private Set<String> set;

	public static final JavaKeyword me = createSharedInstance();

	private static JavaKeyword createSharedInstance() {
		JavaKeyword jk = new JavaKeyword();
		jk.set = Collections.unmodifiableSet(jk.set);	// 共享对象不让修改
		return jk;
	}

	public JavaKeyword() {
		set = new HashSet<String>();
		for (String keyword : keywordArray) {
			set.add(keyword);
		}
	}

	public JavaKeyword addKeyword(String keyword) {
		if (StrKit.notBlank(keyword)) {
			set.add(keyword);
		}
		return this;
	}

	public JavaKeyword removeKeyword(String keyword) {
		set.remove(keyword);
		return this;
	}

	public boolean contains(String str) {
		return set.contains(str);
	}
}






