/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.stat.ast;

import java.util.Map.Entry;

/**
 * ForEntry 包装 HashMap、LinkedHashMap 等 Map 类型的 Entry 对象
 */
public class ForEntry implements Entry<Object, Object> {

	private Entry<Object, Object> entry;

	public void init(Entry<Object, Object> entry) {
		this.entry = entry;
	}

	public Object getKey() {
		return entry.getKey();
	}

	public Object getValue() {
		return entry.getValue();
	}

	public Object setValue(Object value) {
		return entry.setValue(value);
	}
}



