/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.stat.ast;

import cn.aifei.enjoy.Env;
import cn.aifei.enjoy.TemplateException;
import cn.aifei.enjoy.expr.ast.Expr;
import cn.aifei.enjoy.expr.ast.ExprList;
import cn.aifei.enjoy.io.Writer;
import cn.aifei.enjoy.stat.Location;
import cn.aifei.enjoy.stat.ParseException;
import cn.aifei.enjoy.stat.Scope;

/**
 * Case
 */
public class Case extends Stat implements CaseSetter {

	private Expr[] exprArray;
	private Stat stat;
	private Case nextCase;

	public Case(ExprList exprList, StatList statList, Location location) {
		if (exprList.length() == 0) {
			throw new ParseException("The parameter of #case directive can not be blank", location);
		}

		this.exprArray = exprList.getExprArray();
		this.stat = statList.getActualStat();
	}

	public void setNextCase(Case nextCase) {
		this.nextCase = nextCase;
	}

	public void exec(Env env, Scope scope, Writer writer) {
		throw new TemplateException("#case 指令的 exec 不能被调用", location);
	}

	boolean execIfMatch(Object switchValue, Env env, Scope scope, Writer writer) {
		if (exprArray.length == 1) {
			Object value = exprArray[0].eval(scope);

			// 照顾 null == null 以及数值比较小的整型数据比较
			if (value == switchValue) {
				stat.exec(env, scope, writer);
				return true;
			}

			if (value != null && value.equals(switchValue)) {
				stat.exec(env, scope, writer);
				return true;
			}
		} else {
			for (Expr expr : exprArray) {
				Object value = expr.eval(scope);

				// 照顾 null == null 以及数值比较小的整型数据比较
				if (value == switchValue) {
					stat.exec(env, scope, writer);
					return true;
				}

				if (value != null && value.equals(switchValue)) {
					stat.exec(env, scope, writer);
					return true;
				}
			}
		}

		return nextCase != null ? nextCase.execIfMatch(switchValue, env, scope, writer) : false;
	}
}


