/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.stat.ast;

import cn.aifei.enjoy.Env;
import cn.aifei.enjoy.TemplateException;
import cn.aifei.enjoy.expr.ast.ExprList;
import cn.aifei.enjoy.io.Writer;
import cn.aifei.enjoy.stat.Scope;

/**
 * Call 调用模板函数，两种用法：
 * 1：常规调用
 *    #@funcName(p1, p2, ..., pn)
 * 2：安全调用，函数被定义才调用，否则跳过
 *    #@funcName?(p1, p2, ..., pn)
 *
 * 注意：在函数名前面引入 '@' 字符是为了区分模板函数和指令
 */
public class Call extends Stat {

	private String funcName;
	private ExprList exprList;
	private boolean callIfDefined;

	public Call(String funcName, ExprList exprList, boolean callIfDefined) {
		this.funcName = funcName;
		this.exprList = exprList;
		this.callIfDefined = callIfDefined;
	}

	public void exec(Env env, Scope scope, Writer writer) {
		Define function = env.getFunction(funcName);
		if (function != null) {
			function.call(env, scope, exprList, writer);
		} else if (callIfDefined) {
			return ;
		} else {
			throw new TemplateException("Template function not defined: " + funcName, location);
		}
	}
}

