/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.stat;

/**
 * Token
 */
class Token {

	final Symbol symbol;
	final int row;
	private final String value;

	Token(Symbol symbol, String value, int row) {
		if (symbol == null || value == null) {
			throw new IllegalArgumentException("symbol and value can not be null");
		}
		this.symbol = symbol;
		this.value = value;
		this.row = row;
	}

	Token(Symbol symbol, int row) {
		this(symbol, symbol.getName(), row);
	}

	boolean hasPara() {
		return symbol.hasPara();
	}

	boolean noPara() {
		return symbol.noPara();
	}

	public String value() {
		return value;
	}

	public String toString() {
		return value;
	}

	public int getRow() {
		return row;
	}

	public void print() {
		System.out.print("[");
		System.out.print(row);
		System.out.print(", ");
		System.out.print(symbol.getName());
		System.out.print(", ");
		System.out.print(value());
		System.out.println("]");
	}
}


