/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.stat;

/**
 * ParaToken
 */
public class ParaToken extends Token {

	// 接管父类的 value，content 可能为 null
	private StringBuilder content;

	public ParaToken(StringBuilder content, int row) {
		super(Symbol.PARA, row);
		this.content = content;
	}

	public String value() {
		return content.toString();
	}

	public StringBuilder getContent() {
		return content;
	}

	public String toString() {
		return content != null ? content.toString() : "null";
	}

	public void print() {
		System.out.print("[");
		System.out.print(row);
		System.out.print(", PARA, ");
		System.out.print(toString());
		System.out.println("]");
	}
}

