/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.stat;

/**
 * Location
 * 生成异常发生的位置消息
 */
public class Location {

	private String templateFile;
	private int row;
	private String msg;

	public Location(String templateFile, int row) {
		this.templateFile = templateFile;
		this.row = row;
		this.msg = null;
	}

	public String toString() {
		if (msg == null) {
			StringBuilder buf = new StringBuilder();
			if (templateFile != null) {
				buf.append("\nTemplate: \"").append(templateFile).append("\". Line: ").append(row);
			} else {
				buf.append("\nString template line: ").append(row);
			}
			msg = buf.toString();
		}
		return msg;
	}

	public String getTemplateFile() {
		return templateFile;
	}

	public int getRow() {
		return row;
	}
}






