/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.source;

/**
 * ISourceFactory 用于为 engine 切换不同的 ISource 实现类
 *
 * FileSourceFactory 用于从指定的目录中加载模板文件
 * ClassPathSourceFactory 用于从 class path 以及 jar 文件中加载模板文件
 *
 * 配置示例：
 * engine.setSourceFactory(new ClassPathSourceFactory());
 */
@FunctionalInterface
public interface ISourceFactory {
	ISource getSource(String baseTemplatePath, String fileName, String encoding);
}




