/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.source;

/**
 * ISource 用于表示模板内容的来源
 */
public interface ISource {

	/**
	 * reload template if modified on devMode
	 */
	boolean isModified();

	/**
	 * cache key used to cache, return null if do not cache the template
	 *
	 * 注意：如果不希望缓存从该 ISource 解析出来的 Template 对象
	 *      让 getCacheKey() 返回 null 值即可
	 */
	String getCacheKey();

	/**
	 * content of ISource
	 */
	StringBuilder getContent();

	/**
	 * encoding of content
	 */
	String getEncoding();
}


