/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.source;

/**
 * FileSourceFactory 用于配置 Engine 使用 FileSource 加载模板文件
 *
 * 注意：
 *    FileSourceFactory 为模板引擎默认配置
 */
public class FileSourceFactory implements ISourceFactory {

	public ISource getSource(String baseTemplatePath, String fileName, String encoding) {
		return new FileSource(baseTemplatePath, fileName, encoding);
	}
}




