/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.io;

import cn.aifei.kit.TimeKit;

import java.io.IOException;
import java.util.Date;

/**
 * Writer
 */
public abstract class Writer implements AutoCloseable {

	protected DateFormats formats = new DateFormats();

	public abstract void flush() throws IOException;

	public abstract void write(IWritable writable) throws IOException;

	public abstract void write(String string, int offset, int length) throws IOException;

	public abstract void write(String string) throws IOException;

	public abstract void write(StringBuilder stringBuilder, int offset, int length) throws IOException;

	public abstract void write(StringBuilder stringBuilder) throws IOException;

	public abstract void write(boolean booleanValue) throws IOException;

	public abstract void write(int intValue) throws IOException;

	public abstract void write(long longValue) throws IOException;

	public abstract void write(double doubleValue) throws IOException;

	public abstract void write(float floatValue) throws IOException;

	public void write(short shortValue) throws IOException {
		write((int)shortValue);
	}

	public void write(Date date, String datePattern) throws IOException {
		String str = formats.getDateFormat(datePattern).format(date);
		write(str, 0, str.length());
	}

	/**
	 * 格式化输出 LocalDateTime、LocalDate、LocalTime
	 */
	public void write(java.time.temporal.Temporal temporal, String pattern) throws IOException {
		write(TimeKit.getDateTimeFormatter(pattern).format(temporal));
	}
}







