/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.io;

/**
 * JdkEncoderFactory
 *
 * 支持 utf8mb4，支持 emoji 表情字符，支持各种罕见字符编码
 *
 * <pre>
 * 配置方法：
 * engine.setToJdkEncoderFactory();
 * </pre>
 */
public class JdkEncoderFactory extends EncoderFactory {

	@Override
	public Encoder getEncoder() {
		return new JdkEncoder(charset);
	}
}



